package com.github.thedeathlycow.frostiful.mixins.entity.root;

import com.github.thedeathlycow.frostiful.entity.component.FrostWandRootComponent;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

/**
 * This Mixin is necessary since the targeted injection method is overridden by players without a super call
 */
@Mixin(class_1657.class)
public class PlayerMovementBlockMixin {

    @Inject(
            method = "maybeBackOffFromEdge",
            at = @At("HEAD"),
            cancellable = true
    )
    private void blockMovementForRootedEntities(class_243 movement, class_1313 type, CallbackInfoReturnable<class_243> cir) {
        class_1657 instance = (class_1657) (Object) this;

        class_243 adjustedMovement = FrostWandRootComponent.adjustMovementForRoot(type, movement, instance);
        if (adjustedMovement != null) {
            cir.setReturnValue(adjustedMovement);
        }
    }

}
