package com.github.thedeathlycow.frostiful.mixins.powder_snow_effects;

import com.github.thedeathlycow.thermoo.api.temperature.TemperatureAware;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1309.class)
public abstract class LivingEntityPowderSnowDisabler extends class_1297 implements TemperatureAware {

    public LivingEntityPowderSnowDisabler(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Inject(
            method = "canFreeze",
            at = @At(
                    value = "TAIL"
            ),
            cancellable = true
    )
    private void overrideLeatherArmourFreezeImmunity(CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue(super.method_32316());
    }

    @ModifyArg(
            method = "aiStep",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/LivingEntity;setTicksFrozen(I)V"
            )
    )
    private int disableTicksFreezingIncreaseInPowderSnow(int par1) {
        return this.method_32312();
    }

    @Inject(
            method = "tryAddFrost",
            at = @At(
                    value = "HEAD"
            ),
            cancellable = true
    )
    private void blockPowderSnowSlow(CallbackInfo ci) {
        ci.cancel();
    }

    @Inject(
            method = "removeFrost",
            at = @At(
                    value = "HEAD"
            ),
            cancellable = true
    )
    private void dontNeedToRemovePowderSnowSlow(CallbackInfo ci) {
        ci.cancel();
    }


    @ModifyArg(
            method = "aiStep",
            slice = @Slice(
                    from = @At(
                            value = "INVOKE",
                            target = "Lnet/minecraft/world/entity/LivingEntity;tryAddFrost()V"
                    )
            ),
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/LivingEntity;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z",
                    ordinal = 0
            ),
            index = 1
    )
    private float blockPowderSnowFreezeDamage(float amount) {
        return 0f;
    }
}
