package com.github.thedeathlycow.frostiful.mixins.world;

import com.github.thedeathlycow.frostiful.server.world.ChillagerRaidSpawnerUtil;
import com.llamalad7.mixinextras.injector.ModifyReceiver;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3765;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_3765.class)
public class RaidMixin {
    @Shadow @Final private class_3218 level;

    @Inject(
            method = "spawnGroup",
            at = @At("HEAD")
    )
    private void trackIsBiomeCold(
            class_2338 pos,
            CallbackInfo ci,
            @Share("isBiomeCold") LocalBooleanRef isBiomeCold
    ) {
        class_1959 biome = this.level.method_23753(pos).comp_349();

        isBiomeCold.set(biome.method_33599(pos));
    }

    @ModifyReceiver(
            method = "spawnGroup",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/EntityType;create(Lnet/minecraft/world/level/Level;)Lnet/minecraft/world/entity/Entity;"
            )
    )
    private class_1299<?> replacePillagersWithChillagers(
            class_1299<?> instance,
            class_1937 world,
            @Share("isBiomeCold") LocalBooleanRef isBiomeCold
    ) {
        return ChillagerRaidSpawnerUtil.replaceRaidersInColdBiomes(instance, isBiomeCold.get());
    }
}