package com.github.thedeathlycow.frostiful.registry;

import com.github.thedeathlycow.frostiful.Frostiful;
import com.github.thedeathlycow.frostiful.registry.tag.FItemTags;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_156;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_2378;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class FArmorMaterials {


    public static final class_6880<class_1741> FUR = register(
            "fur",
            class_156.method_654(new EnumMap<>(class_1738.class_8051.class), map -> {
                map.put(class_1738.class_8051.field_41937, 1);
                map.put(class_1738.class_8051.field_41936, 2);
                map.put(class_1738.class_8051.field_41935, 3);
                map.put(class_1738.class_8051.field_41934, 1);
            }),
            15,
            FSoundEvents.ITEM_ARMOR_EQUIP_FUR,
            0,
            0,
            () -> class_1856.method_8106(FItemTags.FUR)
    );

    public static final class_6880<class_1741> FUR_LINED_CHAINMAIL = register(
            "fur_lined_chainmail",
            class_156.method_654(new EnumMap<>(class_1738.class_8051.class), map -> {
                map.put(class_1738.class_8051.field_41937, 2);
                map.put(class_1738.class_8051.field_41936, 5);
                map.put(class_1738.class_8051.field_41935, 6);
                map.put(class_1738.class_8051.field_41934, 2);
            }),
            12,
            class_3417.field_15191,
            0,
            0,
            () -> class_1856.method_8091(class_1802.field_8620)
    );


    public static void initialize() {
        Frostiful.LOGGER.debug("Initialized Frostiful armor materials");
    }

    private static class_6880<class_1741> register(
            String id,
            EnumMap<class_1738.class_8051, Integer> defense,
            int enchantability,
            class_6880<class_3414> equipSound,
            float toughness,
            float knockbackResistance,
            Supplier<class_1856> repairIngredient
    ) {
        List<class_1741.class_9196> list = List.of(new class_1741.class_9196(Frostiful.id(id)));
        return register(id, defense, enchantability, equipSound, toughness, knockbackResistance, repairIngredient, list);
    }

    private static class_6880<class_1741> register(
            String id,
            EnumMap<class_1738.class_8051, Integer> defense,
            int enchantability,
            class_6880<class_3414> equipSound,
            float toughness,
            float knockbackResistance,
            Supplier<class_1856> repairIngredient,
            List<class_1741.class_9196> layers
    ) {
        EnumMap<class_1738.class_8051, Integer> defenses = new EnumMap<>(class_1738.class_8051.class);

        for (class_1738.class_8051 type : class_1738.class_8051.values()) {
            defenses.put(type, defense.get(type));
        }

        return class_2378.method_47985(
                class_7923.field_48976,
                Frostiful.id(id),
                new class_1741(
                        defenses,
                        enchantability,
                        equipSound,
                        repairIngredient,
                        layers,
                        toughness,
                        knockbackResistance
                )
        );
    }


    private FArmorMaterials() {

    }
}
