package com.github.thedeathlycow.frostiful.registry;

import com.github.thedeathlycow.frostiful.Frostiful;
import com.github.thedeathlycow.frostiful.block.*;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2315;
import net.minecraft.class_2378;
import net.minecraft.class_2482;
import net.minecraft.class_2498;
import net.minecraft.class_2510;
import net.minecraft.class_2544;
import net.minecraft.class_2591;
import net.minecraft.class_2766;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_4970;
import net.minecraft.class_7923;
import net.minecraft.class_8960;
import net.minecraft.class_9197;
import net.minecraft.world.level.block.*;
import java.util.function.Function;

public class FBlocks {

    public static final class_2248 ICICLE = register(
            "icicle",
            settings -> new IcicleBlock(
                    settings
                            .method_31710(class_3620.field_16026)
                            .method_22488()
                            .method_9626(class_2498.field_11537)
                            .method_9640()
                            .method_9632(0.5F)
                            .method_50012(class_3619.field_15971)
                            .method_9624()
                            .method_49229(class_4970.class_2250.field_10657)
                            .method_29292()
            )
    );

    public static final class_2248 COLD_SUN_LICHEN = register(
            "cold_sun_lichen",
            settings -> new SunLichenBlock(
                    SunLichenBlock.COLD_LEVEL,
                    settings
                            .method_51371()
                            .method_31710(class_3620.field_16020)
                            .method_50012(class_3619.field_15971)
                            .method_9634()
                            .method_9632(0.2f)
                            .method_9626(class_2498.field_28427)
                            .method_9640()
                            .method_22488()
                            .method_9631(state -> 0)
            )
    );
    public static final class_2248 COOL_SUN_LICHEN = register(
            "cool_sun_lichen",
            settings -> new SunLichenBlock(
                    SunLichenBlock.COOL_LEVEL,
                    settings
                            .method_51371()
                            .method_31710(class_3620.field_16020)
                            .method_50012(class_3619.field_15971)
                            .method_9634()
                            .method_9632(0.2f)
                            .method_9626(class_2498.field_28427)
                            .method_9640()
                            .method_22488()
                            .method_9631(state -> 2)
            )
    );
    public static final class_2248 WARM_SUN_LICHEN = register(
            "warm_sun_lichen",
            settings -> new SunLichenBlock(
                    SunLichenBlock.WARM_LEVEL,
                    settings
                            .method_51371()
                            .method_31710(class_3620.field_16020)
                            .method_50012(class_3619.field_15971)
                            .method_9634()
                            .method_9632(0.2f)
                            .method_9626(class_2498.field_28427)
                            .method_9640()
                            .method_22488()
                            .method_9631(state -> 4)
            )
    );
    public static final class_2248 HOT_SUN_LICHEN = register(
            "hot_sun_lichen",
            settings -> new SunLichenBlock(
                    SunLichenBlock.HOT_LEVEL,
                    settings
                            .method_51371()
                            .method_31710(class_3620.field_16020)
                            .method_50012(class_3619.field_15971)
                            .method_9634()
                            .method_9632(0.2f)
                            .method_9626(class_2498.field_28427)
                            .method_9640()
                            .method_22488()
                            .method_9631(state -> 6)
            )
    );

    public static final class_2248 FROZEN_TORCH = register(
            "frozen_torch",
            settings -> new FrozenTorchBlock(
                    settings
                            .method_9634()
                            .method_9618()
                            .method_50012(class_3619.field_15971)
                            .method_9626(class_2498.field_11547)
            )
    );

    public static final class_2248 FROZEN_WALL_TORCH = register(
            "frozen_wall_torch",
            settings -> new FrozenWallTorchBlock(
                    settings
                            .method_16228(FROZEN_TORCH)
            ),
            class_4970.class_2251.method_9630(FROZEN_TORCH)
    );

    public static final class_2248 PACKED_SNOW = register(
            "packed_snow",
            settings -> new PackedSnowBlock(
                    settings
                            .method_31710(class_3620.field_16022)
                            .method_51371()
                            .method_51370()
                            .method_9629(1.2f, 3.0f)
                            .method_29292()
                            .method_9626(FBlockSoundGroups.PACKED_SNOW)
                            .method_9640()
                            .method_26245((state, world, pos) -> {
                                return state.method_11654(PackedSnowBlock.LAYERS) >= PackedSnowBlock.MAX_LAYERS;
                            })
                            .method_50012(class_3619.field_15971)
            )
    );

    public static final class_2248 PACKED_SNOW_BLOCK = register(
            "packed_snow_block",
            settings -> new class_2248(
                    settings
                            .method_31710(class_3620.field_15979)
                            .method_29292()
                            .method_9629(1.5f, 6.0f)
                            .method_9626(FBlockSoundGroups.PACKED_SNOW)
            )
    );

    public static final class_2248 PACKED_SNOW_BRICKS = register(
            "packed_snow_bricks",
            settings -> new class_2248(
                    settings
                            .method_31710(class_3620.field_15979)
                            .method_29292()
                            .method_9629(1.5f, 6.0f)
                            .method_9626(FBlockSoundGroups.PACKED_SNOW)
            )
    );

    public static final class_2248 PACKED_SNOW_BRICK_STAIRS = register(
            "packed_snow_brick_stairs",
            settings -> new class_2510(
                    PACKED_SNOW_BRICKS.method_9564(),
                    settings
            ),
            class_4970.class_2251.method_9630(PACKED_SNOW_BRICKS)
    );

    public static final class_2248 PACKED_SNOW_BRICK_SLAB = register(
            "packed_snow_brick_slab",
            settings -> new class_2482(settings),
            class_4970.class_2251.method_9630(PACKED_SNOW_BRICKS)
    );

    public static final class_2248 PACKED_SNOW_BRICK_WALL = register(
            "packed_snow_brick_wall",
            settings -> new class_2544(settings),
            class_4970.class_2251.method_9630(PACKED_SNOW_BRICKS)
    );

    public static final class_2248 ICE_PANE = register(
            "ice_pane",
            settings -> new IcePaneBlock(
                    settings
                            .method_31710(class_3620.field_16016)
                            .method_9632(0.5f)
                            .method_9640()
                            .method_9628(0.98f)
                            .method_9626(class_2498.field_11537)
                            .method_22488()
                            .method_26236((state, world, pos) -> false)
            )
    );

    public static final class_2248 CUT_PACKED_ICE = register(
            "cut_packed_ice",
            settings -> new class_2248(
                    settings
                            .method_31710(class_3620.field_16016)
                            .method_51368(class_2766.field_12647)
                            .method_9628(0.98f)
                            .method_9632(0.75f)
                            .method_29292()
                            .method_9626(class_2498.field_11537)
            )
    );

    public static final class_2248 CUT_PACKED_ICE_STAIRS = register(
            "cut_packed_ice_stairs",
            settings -> new class_2510(
                    CUT_PACKED_ICE.method_9564(),
                    settings
            ),
            class_4970.class_2251.method_9630(CUT_PACKED_ICE)
    );

    public static final class_2248 CUT_PACKED_ICE_SLAB = register(
            "cut_packed_ice_slab",
            settings -> new class_2482(settings),
            class_4970.class_2251.method_9630(CUT_PACKED_ICE)
    );

    public static final class_2248 CUT_PACKED_ICE_WALL = register(
            "cut_packed_ice_wall",
            settings -> new class_2544(settings),
            class_4970.class_2251.method_9630(CUT_PACKED_ICE)
    );

    public static final class_2248 CUT_BLUE_ICE = register(
            "cut_blue_ice",
            settings -> new class_2248(
                    settings
                            .method_31710(class_3620.field_16016)
                            .method_9628(0.989f)
                            .method_9632(2.8f)
                            .method_29292()
                            .method_9626(class_2498.field_11537)
            )
    );

    public static final class_2248 CUT_BLUE_ICE_STAIRS = register(
            "cut_blue_ice_stairs",
            settings -> new class_2510(
                    CUT_BLUE_ICE.method_9564(),
                    settings
            ),
            class_4970.class_2251.method_9630(CUT_BLUE_ICE)
    );

    public static final class_2248 CUT_BLUE_ICE_SLAB = register(
            "cut_blue_ice_slab",
            settings -> new class_2482(settings),
            class_4970.class_2251.method_9630(CUT_BLUE_ICE)
    );

    public static final class_2248 CUT_BLUE_ICE_WALL = register(
            "cut_blue_ice_wall",
            settings -> new class_2544(settings),
            class_4970.class_2251.method_9630(CUT_BLUE_ICE)
    );

    public static final class_2248 ICY_TRIAL_SPAWNER = register(
            "icy_trial_spawner",
            settings -> new class_8960(
                    settings
                            .method_31710(class_3620.field_25706)
                            .method_51368(class_2766.field_12653)
                            .method_9631(state -> state.method_11654(class_8960.field_47349).method_55209())
                            .method_9632(50.0f)
                            .method_9626(class_2498.field_47346)
                            .method_26245(class_2246::method_26122)
                            .method_22488()
            )
    );
    public static final class_2248 ICY_VAULT = register(
            "icy_vault",
            settings -> new class_9197(
                    settings
                            .method_31710(class_3620.field_25706)
                            .method_51368(class_2766.field_12653)
                            .method_22488()
                            .method_9626(class_2498.field_48855)
                            .method_9631(state -> state.method_11654(class_9197.field_48857).method_56801() * 5 / 6)
                            .method_9632(50.0f)
                            .method_26245(class_2246::method_26122)
            )
    );

    public static final class_2248 BRITTLE_ICE = register(
            "brittle_ice",
            settings -> new BrittleIceBlock(
                    settings
                            .method_31710(class_3620.field_16016)
                            .method_9628(0.98f)
                            .method_9640()
                            .method_9632(0.5f)
                            .method_9626(class_2498.field_11537)
                            .method_22488()
                            .method_26236(class_2246::method_26122)
            )
    );

    public static void initialize() {
        Frostiful.LOGGER.debug("Initialized Frostiful blocks");
        class_2315.method_58681(FItems.GLACIAL_ARROW);
        class_2315.method_58681(FItems.PACKED_SNOWBALL);
        UseBlockCallback.EVENT.register(new CampfireUseEventListener());
        class_2591.field_47352.addSupportedBlock(ICY_TRIAL_SPAWNER);
        class_2591.field_48859.addSupportedBlock(ICY_VAULT);
    }

    private static class_2248 register(String id, Function<class_4970.class_2251, class_2248> blockFactory) {
        return register(id, blockFactory, class_4970.class_2251.method_9637());
    }

    private static class_2248 register(String id, Function<class_4970.class_2251, class_2248> blockFactory, class_4970.class_2251 settings) {
        class_2248 block = blockFactory.apply(settings);
        return class_2378.method_10230(class_7923.field_41175, Frostiful.id(id), block);
    }

    private FBlocks() {

    }

}
