package com.github.thedeathlycow.frostiful.server.command;

import com.github.thedeathlycow.frostiful.entity.component.FrostWandRootComponent;
import com.github.thedeathlycow.frostiful.registry.FComponents;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import net.minecraft.class_2561;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class RootCommand {

    public static void register(CommandDispatcher<class_2168> dispatcher) {

        var rootTarget =
                method_9244("targets", class_2186.method_9306())
                        .then(
                                method_9244("duration", IntegerArgumentType.integer(0))
                                        .executes(
                                                (context) -> {
                                                    return runRoot(context.getSource(),
                                                            class_2186.method_9317(context, "targets"),
                                                            IntegerArgumentType.getInteger(context, "duration"));
                                                }
                                        )
                        );


        dispatcher.register(
                method_9247("root").requires(src -> src.method_9259(2))
                        .then(
                                rootTarget
                        )
        );
    }

    private static int runRoot(class_2168 source, Collection<? extends class_1297> targets, int duration) throws CommandSyntaxException {

        int sum = 0;
        for (class_1297 entity : targets) {
            if (entity instanceof class_1309 livingEntity) {
                FrostWandRootComponent component = FComponents.FROST_WAND_ROOT_COMPONENT.get(livingEntity);
                component.setRootedTicks(duration);
                sum += duration;
            }
        }

        String key = "commands.frostiful.root.set.success." + (targets.size() == 1 ? "single" : "multiple");
        class_2561 msg;
        if (targets.size() == 1) {
            msg = class_2561.method_43469(key, targets.iterator().next().method_5476(), duration);
        } else {
            msg = class_2561.method_43469(key, targets.size(), duration);
        }

        source.method_9226(() -> msg, true);

        return sum;
    }
}
