package com.github.thedeathlycow.frostiful.server.world;

import com.github.thedeathlycow.frostiful.registry.FEntityTypes;
import net.minecraft.class_1948;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_3732;
import net.minecraft.class_3769;
import net.minecraft.class_5819;

public class ChillagerPatrolSpawner {


    /**
     * Essentially a rewrite of {@link class_3769#method_16575(class_3218, class_2338, class_5819, boolean)}, except
     * that it spawns a {@link com.github.thedeathlycow.frostiful.entity.ChillagerEntity} instead of a
     * {@link net.minecraft.class_1604}. Called via mixin as method is private.
     *
     * @param world world to spawn chillager in
     * @param pos position to spawn chillager at
     * @param random random instance
     * @param captain whether the chillager should be a captain
     * @return Returns true if the chillager was spawned
     */
    public static boolean spawnChillagerPatrol(class_3218 world, class_2338 pos, class_5819 random, boolean captain) {
        class_2680 state = world.method_8320(pos);

        if (!class_1948.method_8662(world, pos, state, state.method_26227(), FEntityTypes.CHILLAGER)) {
            return false;
        } else if (!class_3732.method_20739(FEntityTypes.CHILLAGER, world, class_3730.field_16527, pos, random)) {
            return false;
        } else {
            class_3732 patroller = FEntityTypes.CHILLAGER.method_5883(world);
            if (patroller != null) {
                if (captain) {
                    patroller.method_16217(true);
                    patroller.method_16218();
                }

                patroller.method_5814(pos.method_10263(), pos.method_10264(), pos.method_10260());
                patroller.method_5943(world, world.method_8404(pos), class_3730.field_16527, null);

                world.method_30771(patroller);
                return true;
            } else {
                return false;
            }
        }
    }
}
