package com.github.thedeathlycow.frostiful.server.world.gen.feature.coveredrock;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_3037;
import net.minecraft.class_4651;
import net.minecraft.class_6796;
import net.minecraft.class_6880;

/**
 * The config for covered rock features
 *
 * @param base            The base block of the rock, e.g. stone
 * @param size            The size of the rock.
 * @param coveringFeature The feature that will cover the rock
 */
public record CoveredRockFeatureConfig(
        class_4651 base,
        CoveredRockSizeConfig size,
        class_6880<class_6796> coveringFeature,
        float placeCoveringChance
) implements class_3037 {

    public static final Codec<CoveredRockFeatureConfig> CODEC = RecordCodecBuilder.create(
            instance -> instance.group(
                    class_4651.field_24937.fieldOf("base").forGetter(CoveredRockFeatureConfig::base),
                    CoveredRockSizeConfig.CODEC.fieldOf("size").forGetter(CoveredRockFeatureConfig::size),
                    class_6796.field_35730.fieldOf("covering_feature").forGetter(CoveredRockFeatureConfig::coveringFeature),
                    Codec.floatRange(0.0f, 1.0f).fieldOf("place_covering_chance").forGetter(CoveredRockFeatureConfig::placeCoveringChance)
            ).apply(instance, instance.stable(CoveredRockFeatureConfig::new))
    );
}
