package com.github.thedeathlycow.frostiful.survival;

import com.github.thedeathlycow.frostiful.Frostiful;
import com.github.thedeathlycow.frostiful.config.FrostifulConfig;
import com.github.thedeathlycow.frostiful.config.group.EnvironmentConfigGroup;
import com.github.thedeathlycow.frostiful.item.cloak.AbstractFrostologyCloakItem;
import com.github.thedeathlycow.frostiful.registry.FGameRules;
import com.github.thedeathlycow.frostiful.registry.FItems;
import com.github.thedeathlycow.thermoo.api.environment.component.EnvironmentComponentTypes;
import com.github.thedeathlycow.thermoo.api.environment.component.TemperatureRecordComponent;
import com.github.thedeathlycow.thermoo.api.environment.event.ServerPlayerEnvironmentTickEvents;
import com.github.thedeathlycow.thermoo.api.temperature.event.EnvironmentTickContext;
import com.github.thedeathlycow.thermoo.api.util.TemperatureRecord;
import com.github.thedeathlycow.thermoo.api.util.TemperatureUnit;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_3222;
import net.minecraft.class_3532;

public final class ServerPlayerEnvironmentTickListeners {

    public static void initialize() {
        ServerPlayerEnvironmentTickEvents.GET_TEMPERATURE_CHANGE.register(ServerPlayerEnvironmentTickListeners::getTemperatureChange);
        ServerPlayerEnvironmentTickEvents.ALLOW_TEMPERATURE_CHANGE.register(ServerPlayerEnvironmentTickListeners::allowTemperatureChange);
    }

    private static int getTemperatureChange(EnvironmentTickContext<class_3222> context) {
        if (context.affected().method_7325()) {
            return 0;
        }

        TemperatureRecord temperature = context.components()
                .method_57830(EnvironmentComponentTypes.TEMPERATURE, TemperatureRecordComponent.DEFAULT);

        EnvironmentConfigGroup config = Frostiful.getConfig().environmentConfig;
        int total = envTemperatureToTemperaturePoint(temperature, config);

        if (total < 0 && context.affected().thermoo$isWet()) {
            total = (int) (total * Frostiful.getConfig().environmentConfig.getEnvironmentFreezingSoakedMultiplier());
        }

        if (context.affected().field_6012 % 20 == 0 && Frostiful.LOGGER.isDebugEnabled()) {
            Frostiful.LOGGER.debug("Adding {} temperature to {}", total, context.affected().method_5820());
        }

        return total;
    }

    private static TriState allowTemperatureChange(EnvironmentTickContext<class_3222> context, int temperatureChange) {
        if (temperatureChange > 0) {
            return TriState.DEFAULT;
        }

        FrostifulConfig config = Frostiful.getConfig();
        class_3222 player = context.affected();

        int tickInterval = config.freezingConfig.getPassiveFreezingTickInterval();
        if (tickInterval > 1 && player.field_6012 % tickInterval != 0) {
            return TriState.FALSE;
        }

        if (player.thermoo$getTemperatureScale() < -config.freezingConfig.getMaxPassiveFreezingPercent()) {
            return TriState.FALSE;
        }

        boolean doPassiveFreezing = config.freezingConfig.doPassiveFreezing()
                && player.method_37908().method_8450().method_8355(FGameRules.DO_PASSIVE_FREEZING);

        if (doPassiveFreezing) {
            return TriState.TRUE;
        } else {
            return TriState.of(
                    AbstractFrostologyCloakItem.isWearing(
                            player,
                            stack -> stack.method_31574(FItems.FROSTOLOGY_CLOAK)
                    )
            );
        }
    }

    public static int envTemperatureToTemperaturePoint(TemperatureRecord temperature) {
        return envTemperatureToTemperaturePoint(temperature, new EnvironmentConfigGroup());
    }

    public static int envTemperatureToTemperaturePoint(TemperatureRecord temperature, EnvironmentConfigGroup configGroup) {
        double temperatureC = temperature
                .valueInUnit(TemperatureUnit.CELSIUS);

        double thresholdC = configGroup.getMaxTemperatureForColdC();
        double degreesPerTemperatureDecrease = configGroup.getDegreesCPerTemperatureDecrease();

        if (temperatureC > thresholdC) {
            return 0;
        }
        // Graphical proof: https://www.desmos.com/calculator/01nd0aidxh
        double base = (temperatureC - thresholdC - degreesPerTemperatureDecrease) / degreesPerTemperatureDecrease;
        return class_3532.method_15384(configGroup.getEnvironmentTemperatureMultiplier() * base);
    }

    private ServerPlayerEnvironmentTickListeners() {

    }
}