package com.github.thedeathlycow.frostiful.survival;

import com.github.thedeathlycow.frostiful.Frostiful;
import com.github.thedeathlycow.frostiful.compat.FrostifulIntegrations;
import com.github.thedeathlycow.frostiful.config.FrostifulConfig;
import com.github.thedeathlycow.frostiful.mixins.entity.EntityInvoker;
import com.github.thedeathlycow.thermoo.api.temperature.event.EnvironmentTickContext;
import com.github.thedeathlycow.thermoo.api.temperature.event.LivingEntitySoakingTickEvents;
import net.minecraft.class_1309;
import net.minecraft.class_1944;
import net.minecraft.class_2246;

public final class SoakingEffects {
    public static void initialize() {
        // scorchful overrides these effects
        if (!FrostifulIntegrations.isModLoaded(FrostifulIntegrations.SCORCHFUL_ID)) {
            LivingEntitySoakingTickEvents.GET_SOAKING_CHANGE.register(SoakingEffects::getSoakingChange);
        } else {
            Frostiful.LOGGER.info("Scorchful has been detected. Frostiful will not affect soaking.");
        }
    }

    private static int getSoakingChange(EnvironmentTickContext<? extends class_1309> context) {
        if (context.affected().method_7325()) {
            return 0;
        }

        EntityInvoker invoker = (EntityInvoker) context.affected();
        FrostifulConfig config = Frostiful.getConfig();
        int total = 0;

        // increase wetness
        total += getRainChange(invoker, config);
        total += getTouchingWaterChange(context, config);
        total += getSubmerged(context, invoker);

        // drying effects
        total -= getLightDrying(context);
        total -= getOnFireDrying(context, config);

        return total;
    }

    private static int getRainChange(EntityInvoker invoker, FrostifulConfig config) {
        return invoker.frostiful$invokeIsBeingRainedOn()
                ? config.environmentConfig.getRainWetnessIncrease()
                : 0;
    }

    private static int getTouchingWaterChange(EnvironmentTickContext<? extends class_1309> context, FrostifulConfig config) {
        class_1309 entity = context.affected();
        return entity.method_5799() || entity.method_55667().method_27852(class_2246.field_27097)
                ? config.environmentConfig.getTouchingWaterWetnessIncrease()
                : 0;
    }

    private static int getSubmerged(EnvironmentTickContext<? extends class_1309> context, EntityInvoker invoker) {
        class_1309 entity = context.affected();
        return entity.method_5869() || invoker.frostiful$invokeIsInsideBubbleColumn()
                ? entity.thermoo$getMaxWetTicks()
                : 0;
    }

    private static int getLightDrying(EnvironmentTickContext<? extends class_1309> context) {
        int blockLightLevel = context.world().method_8314(class_1944.field_9282, context.pos());
        return blockLightLevel / 4;
    }

    private static int getOnFireDrying(EnvironmentTickContext<? extends class_1309> context, FrostifulConfig config) {
        return context.affected().method_5809()
                ? config.environmentConfig.getOnFireDryDate()
                : 0;
    }

    private SoakingEffects() {

    }
}