package com.github.thedeathlycow.frostiful.util;

import net.minecraft.class_2382;
import net.minecraft.class_243;
import org.joml.Vector3f;

public class FMathHelper {

    /**
     * Returns the mid point of two vectors.
     *
     * @param vec1 First vector
     * @param vec2 Second vector
     * @return Returns a new vector that represents the mid point between
     * the two vectors. If the vectors are equal, returns the first vector.
     */
    public static Vector3f getMidPoint(Vector3f vec1, Vector3f vec2) {
        return vec1.equals(vec2) ? vec1 : new Vector3f(
                (vec1.x() + vec2.x()) / 2,
                (vec1.y() + vec2.y()) / 2,
                (vec1.z() + vec2.z()) / 2
        );
    }

    /**
     * Returns the mid point of two vectors.
     *
     * @param vec1 First vector
     * @param vec2 Second vector
     * @return Returns a new vector that represents the mid point between
     * the two vectors. If the vectors are equal, returns the first vector.
     */
    public static class_2382 getMidPoint(class_2382 vec1, class_2382 vec2) {
        return vec1.equals(vec2) ? vec1 : new class_2382(
                (vec1.method_10263() + vec2.method_10263()) / 2,
                (vec1.method_10264() + vec2.method_10264()) / 2,
                (vec1.method_10260() + vec2.method_10260()) / 2
        );
    }

    /**
     * Returns the mid point of two vectors.
     *
     * @param vec1 First vector
     * @param vec2 Second vector
     * @return Returns a new vector that represents the mid point between
     * the two vectors. If the vectors are equal, returns the first vector.
     */
    public static class_243 getMidPoint(class_243 vec1, class_243 vec2) {
        return vec1.equals(vec2) ? vec1 : new class_243(
                (vec1.method_10216() + vec2.method_10216()) / 2,
                (vec1.method_10214() + vec2.method_10214()) / 2,
                (vec1.method_10215() + vec2.method_10215()) / 2
        );
    }
}
