/*
 * Decompiled with CFR 0.152.
 */
package net.nebula.tmmac.checks;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1294;
import net.minecraft.class_1934;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class JumpCheck {
    private static final Map<class_3222, Double> prevY = new HashMap<class_3222, Double>();
    private static final Map<class_3222, Boolean> prevOnGround = new HashMap<class_3222, Boolean>();
    private static final Map<class_3222, Double> prevVelY = new HashMap<class_3222, Double>();

    public static void onServerTick(MinecraftServer server) {
        for (class_3222 player : server.method_3760().method_14571()) {
            double currentVelY;
            if (player.field_13974.method_14257() == class_1934.field_9220 || player.field_13974.method_14257() == class_1934.field_9219) continue;
            double lastY = prevY.getOrDefault(player, player.method_23318());
            boolean lastOnGround = prevOnGround.getOrDefault(player, player.method_24828());
            double lastVelY = prevVelY.getOrDefault(player, 0.0);
            if (JumpCheck.isJump(player, lastVelY, currentVelY = player.method_23318() - lastY, lastOnGround)) {
                JumpCheck.onPlayerJump(player);
            }
            prevY.put(player, player.method_23318());
            prevOnGround.put(player, player.method_24828());
            prevVelY.put(player, currentVelY);
        }
    }

    private static boolean isJump(class_3222 player, double lastVelY, double currentVelY, boolean lastOnGround) {
        if (!lastOnGround) {
            return false;
        }
        if (lastVelY > 0.0) {
            return false;
        }
        if (player.method_6101() || player.method_5681() || player.method_5765() || player.method_6059(class_1294.field_5902)) {
            return false;
        }
        double jumpBoost = player.method_6059(class_1294.field_5913) ? 0.1 * (double)(Objects.requireNonNull(player.method_6112(class_1294.field_5913)).method_5578() + 1) : 0.0;
        double expectedJumpVelocity = (double)0.42f + jumpBoost;
        if (currentVelY > expectedJumpVelocity + 0.01) {
            return JumpCheck.isSlimeBelow(player);
        }
        return Math.abs(currentVelY - expectedJumpVelocity) < 0.01;
    }

    private static boolean isSlimeBelow(class_3222 player) {
        class_2338 posBelow = player.method_24515().method_10074();
        return player.method_37908().method_8320(posBelow).method_27852(class_2246.field_10030);
    }

    private static void onPlayerJump(class_3222 player) {
        double prevYPosition = prevY.getOrDefault(player, player.method_23318());
        double prevX = player.method_23317();
        double prevZ = player.method_23321();
        if (!player.method_5687(2)) {
            player.method_6082(prevX, prevYPosition, prevZ, false);
            player.method_18800(0.0, 0.0, 0.0);
        }
        prevVelY.put(player, 0.0);
    }
}

