/*
 * Decompiled with CFR 0.152.
 */
package net.nebula.tmmac.command;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.server.MinecraftServer;

public class Storage {
    private static final Gson GSON = new Gson();
    private static final Type MAP_TYPE = new TypeToken<Map<String, Float>>(){}.getType();
    private static final String FILE_NAME = "config/tmmac.json";
    private static Map<String, Float> configValues = new HashMap<String, Float>();

    public static void load(MinecraftServer server) {
        File file = new File(server.method_3831().toFile(), FILE_NAME);
        if (!file.exists()) {
            return;
        }
        try (FileReader reader = new FileReader(file);){
            Map loaded = (Map)GSON.fromJson((Reader)reader, MAP_TYPE);
            if (loaded != null) {
                configValues = loaded;
            } else {
                if (!configValues.containsValue("gunrange")) {
                    configValues.put("gunrange", Float.valueOf(18.0f));
                }
                if (!configValues.containsValue("kniferange")) {
                    configValues.put("kniferange", Float.valueOf(4.0f));
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void save(MinecraftServer server) {
        File file = new File(server.method_3831().toFile(), FILE_NAME);
        file.getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(file);){
            GSON.toJson(configValues, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void set(String key, float value, MinecraftServer server) {
        configValues.put(key, Float.valueOf(value));
        Storage.save(server);
    }

    public static float load(String key) {
        float value = configValues.getOrDefault(key, Float.valueOf(0.0f)).floatValue();
        return value;
    }

    public static Map<String, Float> getAll() {
        return configValues;
    }
}

