/*
 * Decompiled with CFR 0.152.
 */
package com.theendercore.hydra.client.twitch;

import com.github.philippheuer.credentialmanager.domain.OAuth2Credential;
import com.github.twitch4j.TwitchClient;
import com.github.twitch4j.TwitchClientBuilder;
import com.github.twitch4j.chat.events.channel.ChannelMessageEvent;
import com.github.twitch4j.eventsub.events.ChannelSubscribeEvent;
import com.github.twitch4j.eventsub.events.ChannelSubscriptionGiftEvent;
import com.github.twitch4j.eventsub.events.ChannelSubscriptionMessageEvent;
import com.github.twitch4j.eventsub.events.CustomRewardRedemptionAddEvent;
import com.github.twitch4j.eventsub.socket.IEventSubSocket;
import com.github.twitch4j.eventsub.subscriptions.ChannelFollowTypeV2;
import com.github.twitch4j.eventsub.subscriptions.ChannelPointsCustomRewardRedemptionAddType;
import com.github.twitch4j.eventsub.subscriptions.ChannelSubscribeType;
import com.github.twitch4j.eventsub.subscriptions.ChannelSubscriptionGiftType;
import com.github.twitch4j.eventsub.subscriptions.ChannelSubscriptionMessageType;
import com.github.twitch4j.eventsub.subscriptions.SubscriptionType;
import com.github.twitch4j.eventsub.subscriptions.SubscriptionTypes;
import com.github.twitch4j.helix.TwitchHelix;
import com.github.twitch4j.helix.domain.User;
import com.github.twitch4j.helix.domain.UserList;
import com.theendercore.hydra.client.HydraMod;
import com.theendercore.hydra.client.config.HydraConfig;
import com.theendercore.hydra.client.twitch.EventSubListeners;
import com.theendercore.hydra.client.util.MethodsKt;
import com.theendercore.hydra.client.util.TextUtilsKt;
import com.theendercore.hydra.client.util.TwitchKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\u0006R\u0016\u0010\t\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b\t\u0010\nR\u0016\u0010\f\u001a\u00020\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b\f\u0010\rR\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/theendercore/hydra/client/twitch/TwitchBot;", "", "<init>", "()V", "", "enable", "()I", "disable", "", "ENABLED", "Z", "Lcom/github/twitch4j/TwitchClient;", "client", "Lcom/github/twitch4j/TwitchClient;", "Lcom/github/philippheuer/credentialmanager/domain/OAuth2Credential;", "credential", "Lcom/github/philippheuer/credentialmanager/domain/OAuth2Credential;", "Lcom/github/twitch4j/eventsub/socket/IEventSubSocket;", "eventSocket", "Lcom/github/twitch4j/eventsub/socket/IEventSubSocket;", "hydra_client"})
@Environment(value=EnvType.CLIENT)
public final class TwitchBot {
    @NotNull
    public static final TwitchBot INSTANCE = new TwitchBot();
    @JvmField
    public static boolean ENABLED;
    @JvmField
    @NotNull
    public static TwitchClient client;
    @JvmField
    @Nullable
    public static OAuth2Credential credential;
    @JvmField
    @Nullable
    public static IEventSubSocket eventSocket;

    private TwitchBot() {
    }

    public final int enable() {
        int n;
        if (ENABLED) {
            n = 0;
        } else {
            ENABLED = true;
            credential = new OAuth2Credential("twitch", HydraMod.config.credentials.getOauthKey());
            boolean usernameInvalid = Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)HydraMod.config.credentials.username)).toString(), (Object)"");
            boolean oauthKeyInvalid = Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)HydraMod.config.credentials.username)).toString(), (Object)"");
            if (usernameInvalid || oauthKeyInvalid) {
                if (usernameInvalid) {
                    MethodsKt.addChatMsg((class_2561)TextUtilsKt.redText("command.hydra.error.config.username"));
                }
                if (oauthKeyInvalid) {
                    MethodsKt.addChatMsg((class_2561)TextUtilsKt.redText("command.hydra.error.config.oauthKey"));
                }
                return 0;
            }
            if (HydraMod.twitchClient != null) {
                String[] stringArray = new String[]{HydraMod.config.credentials.username};
                MethodsKt.addChatMsg((class_2561)TextUtilsKt.darkGrayText("command.hydra.connected.already", stringArray));
                return 0;
            }
            String[] stringArray = new String[]{HydraMod.config.credentials.username};
            MethodsKt.addChatMsg((class_2561)TextUtilsKt.darkGrayText("command.hydra.connecting", stringArray));
            HydraMod.twitchClient = TwitchClientBuilder.builder().withEnableHelix(Boolean.valueOf(true)).withEnableChat(Boolean.valueOf(true)).withEnableEventSocket(Boolean.valueOf(true)).withChatAccount(credential).withDefaultAuthToken(credential).build();
            MethodsKt.addChatMsg((class_2561)TextUtilsKt.darkGrayText("command.hydra.connected"));
            OAuth2Credential oAuth2Credential = credential;
            Intrinsics.checkNotNull((Object)oAuth2Credential);
            if (oAuth2Credential.getUserName() == null) {
                MethodsKt.addChatMsg((class_2561)TextUtilsKt.redText("command.hydra.error.token.incorrect"));
                this.disable();
                return 0;
            }
            if (HydraMod.config.getExtras()) {
                TwitchClient twitchClient = HydraMod.twitchClient;
                Intrinsics.checkNotNull((Object)twitchClient);
                TwitchHelix twitchHelix = twitchClient.getHelix();
                OAuth2Credential oAuth2Credential2 = credential;
                Intrinsics.checkNotNull((Object)oAuth2Credential2);
                UserList fetchedUsers = (UserList)twitchHelix.getUsers(oAuth2Credential2.getAccessToken(), null, CollectionsKt.listOf((Object)HydraMod.config.credentials.username)).execute();
                if (fetchedUsers.getUsers().isEmpty()) {
                    throw new IllegalStateException(("Failed to get users! " + fetchedUsers.getPagination()).toString());
                }
                try {
                    HydraConfig.CredentialsSection credentialsSection = HydraMod.config.credentials;
                    String string = ((User)fetchedUsers.getUsers().get(0)).getId();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
                    credentialsSection.setBroadcasterId(string);
                    HydraMod.config.save();
                }
                catch (Exception e) {
                    HydraMod.LOGGER.error("Filed to set broadcasterId", (Throwable)e);
                }
                TwitchClient twitchClient2 = HydraMod.twitchClient;
                Intrinsics.checkNotNull((Object)twitchClient2);
                eventSocket = twitchClient2.getEventSocket();
                ChannelFollowTypeV2 channelFollowTypeV2 = SubscriptionTypes.CHANNEL_FOLLOW_V2;
                Intrinsics.checkNotNullExpressionValue((Object)channelFollowTypeV2, (String)"CHANNEL_FOLLOW_V2");
                TwitchKt.register((SubscriptionType)channelFollowTypeV2, EventSubListeners.INSTANCE::followingEventListener);
                ChannelPointsCustomRewardRedemptionAddType channelPointsCustomRewardRedemptionAddType = SubscriptionTypes.CHANNEL_POINTS_CUSTOM_REWARD_REDEMPTION_ADD;
                Intrinsics.checkNotNullExpressionValue((Object)channelPointsCustomRewardRedemptionAddType, (String)"CHANNEL_POINTS_CUSTOM_REWARD_REDEMPTION_ADD");
                TwitchKt.register((SubscriptionType)channelPointsCustomRewardRedemptionAddType, TwitchBot::enable$lambda$0);
                ChannelSubscribeType channelSubscribeType = SubscriptionTypes.CHANNEL_SUBSCRIBE;
                Intrinsics.checkNotNullExpressionValue((Object)channelSubscribeType, (String)"CHANNEL_SUBSCRIBE");
                TwitchKt.register((SubscriptionType)channelSubscribeType, TwitchBot::enable$lambda$1);
                ChannelSubscriptionGiftType channelSubscriptionGiftType = SubscriptionTypes.CHANNEL_SUBSCRIPTION_GIFT;
                Intrinsics.checkNotNullExpressionValue((Object)channelSubscriptionGiftType, (String)"CHANNEL_SUBSCRIPTION_GIFT");
                TwitchKt.register((SubscriptionType)channelSubscriptionGiftType, TwitchBot::enable$lambda$2);
                ChannelSubscriptionMessageType channelSubscriptionMessageType = SubscriptionTypes.CHANNEL_SUBSCRIPTION_MESSAGE;
                Intrinsics.checkNotNullExpressionValue((Object)channelSubscriptionMessageType, (String)"CHANNEL_SUBSCRIPTION_MESSAGE");
                TwitchKt.register((SubscriptionType)channelSubscriptionMessageType, TwitchBot::enable$lambda$3);
                MethodsKt.addChatMsg((class_2561)TextUtilsKt.grayText("command.hydra.extras.enable"));
            }
            TwitchClient twitchClient = HydraMod.twitchClient;
            Intrinsics.checkNotNull((Object)twitchClient);
            twitchClient.getEventManager().onEvent(ChannelMessageEvent.class, EventSubListeners.INSTANCE::channelMessageListener);
            n = 1;
        }
        return n;
    }

    public final int disable() {
        int n;
        if (ENABLED) {
            TwitchClient twitchClient = HydraMod.twitchClient;
            if (twitchClient != null) {
                twitchClient.close();
            }
            HydraMod.twitchClient = null;
            MethodsKt.addChatMsg((class_2561)TextUtilsKt.grayText("command.hydra.disconnected"));
            ENABLED = false;
            n = 1;
        } else {
            MethodsKt.addChatMsg((class_2561)TextUtilsKt.darkGrayText("command.hydra.not_connected"));
            n = 0;
        }
        return n;
    }

    private static final void enable$lambda$0(CustomRewardRedemptionAddEvent it) {
        String string = it.getReward().getTitle();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTitle(...)");
        String string2 = it.getUserName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUserName(...)");
        EventSubListeners.INSTANCE.channelPointEvent(string, string2);
    }

    private static final void enable$lambda$1(ChannelSubscribeEvent it) {
        if (!it.isGift().booleanValue()) {
            Intrinsics.checkNotNull((Object)it);
            EventSubListeners.INSTANCE.subEvent(it);
        }
    }

    private static final void enable$lambda$2(ChannelSubscriptionGiftEvent it) {
        Intrinsics.checkNotNull((Object)it);
        EventSubListeners.INSTANCE.subEvent(it);
    }

    private static final void enable$lambda$3(ChannelSubscriptionMessageEvent it) {
        Intrinsics.checkNotNull((Object)it);
        EventSubListeners.INSTANCE.subEvent(it);
    }

    static {
        TwitchClient twitchClient = TwitchClientBuilder.builder().build();
        Intrinsics.checkNotNullExpressionValue((Object)twitchClient, (String)"build(...)");
        client = twitchClient;
    }
}

