/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.api.external.papi.entries;

import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.leralix.tan.api.external.papi.entries.PapiEntry;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.storage.stored.PlayerDataStorage;

public class PlayerNameIsTownLeader
extends PapiEntry {
    public PlayerNameIsTownLeader() {
        super("player_{}_is_town_overlord");
    }

    @Override
    public String getData(OfflinePlayer player, @NotNull String params) {
        ITanPlayer tanPlayer = PlayerDataStorage.getInstance().get(player.getUniqueId());
        if (tanPlayer == null) {
            return "[TAN] Player data not found";
        }
        String[] values = PlayerNameIsTownLeader.extractValues(params);
        if (values.length == 0) {
            return Lang.INVALID_VALUE.get(tanPlayer);
        }
        String playerName = values[0];
        if (playerName == null || playerName.isEmpty()) {
            return Lang.INVALID_PLAYER_NAME.get(tanPlayer);
        }
        OfflinePlayer playerSelected = Bukkit.getOfflinePlayer((String)playerName);
        ITanPlayer tanPlayer1 = PlayerDataStorage.getInstance().get(playerSelected);
        if (tanPlayer1 == null) {
            return Lang.INVALID_NAME.get(tanPlayer);
        }
        return tanPlayer1.isTownOverlord() ? "TRUE" : "FALSE";
    }
}

