/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.api.internal.wrappers;

import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.inventory.ItemStack;
import org.leralix.tan.api.internal.wrappers.TerritoryDataWrapper;
import org.leralix.tan.dataclass.Landmark;
import org.leralix.tan.dataclass.territory.TownData;
import org.leralix.tan.storage.stored.TownDataStorage;
import org.leralix.tan.utils.gameplay.TerritoryUtil;
import org.tan.api.interfaces.TanLandmark;
import org.tan.api.interfaces.TanTerritory;

public class LandmarkDataWrapper
implements TanLandmark {
    Landmark landmark;

    private LandmarkDataWrapper(Landmark landmark) {
        this.landmark = landmark;
    }

    public static LandmarkDataWrapper of(Landmark landmark) {
        if (landmark == null) {
            return null;
        }
        return new LandmarkDataWrapper(landmark);
    }

    @Override
    public String getID() {
        return this.landmark.getID();
    }

    @Override
    public String getName() {
        return this.landmark.getName();
    }

    @Override
    public Location getLocation() {
        return this.landmark.getLocation();
    }

    @Override
    public void setName(String s) {
        this.landmark.setName(s);
    }

    @Override
    public void setQuantity(int i) {
        ItemStack reward = this.landmark.getResources();
        reward.setAmount(i);
        this.landmark.setReward(reward);
    }

    @Override
    public int getQuantity() {
        return this.landmark.getResources().getAmount();
    }

    @Override
    public void setItem(ItemStack itemStack) {
        itemStack.setAmount(this.landmark.getResources().getAmount());
        this.landmark.setReward(itemStack);
    }

    @Override
    public ItemStack getItem() {
        return this.landmark.getResources();
    }

    @Override
    public boolean isOwned() {
        return this.landmark.isOwned();
    }

    @Override
    public TanTerritory getOwner() {
        return TerritoryDataWrapper.of(TerritoryUtil.getTerritory(this.landmark.getOwnerID()));
    }

    @Override
    public void removeOwnership() {
        this.landmark.removeOwnership();
    }

    @Override
    public void setOwner(UUID uuid) {
        this.landmark.setOwner((TownData)TownDataStorage.getInstance().get(uuid.toString()));
    }

    @Override
    public void setOwner(TanTerritory tanTerritory) {
        if (tanTerritory instanceof TownData) {
            TownData townData = (TownData)((Object)tanTerritory);
            this.landmark.setOwner(townData);
        }
    }
}

