/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.commands.player;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import org.leralix.lib.commands.PlayerSubCommand;
import org.leralix.tan.enums.ChunkType;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.storage.PlayerAutoClaimStorage;
import org.leralix.tan.utils.text.TanChatUtils;

public class AutoClaimCommand
extends PlayerSubCommand {
    public String getName() {
        return "autoclaim";
    }

    public String getDescription() {
        return Lang.TOWN_AUTO_CLAIM_DESC.getDefault();
    }

    public int getArguments() {
        return 1;
    }

    public String getSyntax() {
        return "/tan autoclaim <chunk type>";
    }

    public List<String> getTabCompleteSuggestions(Player player, String lowerCase, String[] args) {
        ArrayList<String> suggestions = new ArrayList<String>();
        if (args.length == 2) {
            for (ChunkType chunkType : ChunkType.values()) {
                suggestions.add(chunkType.getName());
            }
            suggestions.add("stop");
        }
        return suggestions;
    }

    public void perform(Player player, String[] args) {
        String message;
        if (args.length != 2) {
            TanChatUtils.message(player, Lang.CORRECT_SYNTAX_INFO.get(player, this.getSyntax()));
            return;
        }
        switch (message = args[1]) {
            case "town": {
                PlayerAutoClaimStorage.addPlayer(player, ChunkType.TOWN);
                TanChatUtils.message(player, Lang.AUTO_CLAIM_ON_FOR.get(player, ChunkType.TOWN.getName()));
                break;
            }
            case "region": {
                PlayerAutoClaimStorage.addPlayer(player, ChunkType.REGION);
                TanChatUtils.message(player, Lang.AUTO_CLAIM_ON_FOR.get(player, ChunkType.REGION.getName()));
                break;
            }
            case "stop": {
                PlayerAutoClaimStorage.removePlayer(player);
                TanChatUtils.message(player, Lang.AUTO_CLAIM_OFF.get(player));
                break;
            }
            default: {
                TanChatUtils.message(player, Lang.CORRECT_SYNTAX_INFO.get(player, this.getSyntax()));
            }
        }
    }
}

