/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.dataclass.territory.economy;

import dev.triumphteam.gui.guis.Gui;
import dev.triumphteam.gui.guis.GuiItem;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.leralix.lib.data.SoundEnum;
import org.leralix.lib.utils.SoundUtil;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.dataclass.territory.TownData;
import org.leralix.tan.dataclass.territory.economy.ProfitLine;
import org.leralix.tan.economy.EconomyUtil;
import org.leralix.tan.enums.RolePermission;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.gui.cosmetic.IconManager;
import org.leralix.tan.gui.user.territory.TreasuryMenu;
import org.leralix.tan.gui.user.territory.history.TerritoryTransactionHistory;
import org.leralix.tan.lang.FilledLang;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.listeners.chat.PlayerChatListenerStorage;
import org.leralix.tan.listeners.chat.events.treasury.SetTerritoryTax;
import org.leralix.tan.storage.database.transactions.TransactionType;
import org.leralix.tan.storage.stored.PlayerDataStorage;
import org.leralix.tan.utils.text.StringUtil;
import org.leralix.tan.utils.text.TanChatUtils;

public class PlayerTaxLine
extends ProfitLine {
    double actualTaxes = 0.0;
    double missingTaxes = 0.0;

    public PlayerTaxLine(TownData townData) {
        super(townData);
        double flatTax = townData.getTax();
        for (String playerID : townData.getPlayerIDList()) {
            ITanPlayer othertanPlayer = PlayerDataStorage.getInstance().get(playerID);
            OfflinePlayer otherPlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(playerID));
            if (!othertanPlayer.getTownRank().isPayingTaxes()) continue;
            if (EconomyUtil.getBalance(otherPlayer) < flatTax) {
                this.missingTaxes += flatTax;
                continue;
            }
            this.actualTaxes += flatTax;
        }
    }

    @Override
    protected double getMoney() {
        return this.actualTaxes;
    }

    @Override
    public FilledLang getLine() {
        if (this.missingTaxes > 0.0) {
            return Lang.PLAYER_TAX_MISSING_LINE.get(StringUtil.getColoredMoney(this.getMoney()), StringUtil.formatMoney(this.missingTaxes));
        }
        return Lang.PLAYER_TAX_LINE.get(StringUtil.getColoredMoney(this.getMoney()));
    }

    @Override
    public void addItems(Gui gui, Player player, LangType lang) {
        ITanPlayer tanPlayer = PlayerDataStorage.getInstance().get(player);
        gui.setItem(2, 2, this.getDecreaseButton(player, lang, tanPlayer));
        gui.setItem(2, 3, this.getInfoIcon(player, lang, tanPlayer));
        gui.setItem(2, 4, this.getIncreaseButton(player, lang, tanPlayer));
    }

    private GuiItem getIncreaseButton(Player player, LangType lang, ITanPlayer tanPlayer) {
        return IconManager.getInstance().get(IconKey.TAX_INCREASE_ICON).setName(Lang.GUI_TREASURY_INCREASE_TAX.get(lang, new String[0])).setDescription(Lang.GUI_INCREASE_1_DESC.get(), Lang.GUI_INCREASE_10_DESC.get()).setAction(action -> {
            action.setCancelled(true);
            if (!this.territoryData.doesPlayerHavePermission(tanPlayer, RolePermission.MANAGE_TAXES)) {
                TanChatUtils.message(player, Lang.PLAYER_NO_PERMISSION.get(lang, new String[0]));
                return;
            }
            int amountToAdd = action.isShiftClick() ? 10 : 1;
            this.territoryData.addToTax(amountToAdd);
            SoundUtil.playSound((Player)player, (SoundEnum)SoundEnum.ADD);
            new TreasuryMenu(player, this.territoryData);
        }).asGuiItem(player, lang);
    }

    private GuiItem getInfoIcon(Player player, LangType lang, ITanPlayer tanPlayer) {
        return IconManager.getInstance().get(IconKey.TAX_INFO_ICON).setName(Lang.GUI_TREASURY_FLAT_TAX.get(lang, new String[0])).setDescription(Lang.GUI_TREASURY_FLAT_TAX_DESC1.get(StringUtil.formatMoney(this.territoryData.getTax())), Lang.GUI_GENERIC_CLICK_TO_OPEN_HISTORY.get(), Lang.RIGHT_CLICK_TO_SET_TAX.get()).setAction(action -> {
            action.setCancelled(true);
            if (!this.territoryData.doesPlayerHavePermission(tanPlayer, RolePermission.MANAGE_TAXES)) {
                TanChatUtils.message(player, Lang.PLAYER_NO_PERMISSION.get(lang, new String[0]));
                return;
            }
            if (action.isLeftClick()) {
                new TerritoryTransactionHistory(player, this.territoryData, TransactionType.TAXES, p -> new TreasuryMenu(player, this.territoryData));
            } else if (action.isRightClick()) {
                TanChatUtils.message(player, Lang.TOWN_SET_TAX_IN_CHAT.get(lang, new String[0]));
                PlayerChatListenerStorage.register(player, new SetTerritoryTax(this.territoryData, p -> new TreasuryMenu(player, this.territoryData)));
            }
        }).asGuiItem(player, lang);
    }

    private GuiItem getDecreaseButton(Player player, LangType lang, ITanPlayer tanPlayer) {
        return IconManager.getInstance().get(IconKey.TAX_DECREASE_ICON).setName(Lang.GUI_TREASURY_LOWER_TAX.get(lang, new String[0])).setDescription(Lang.GUI_DECREASE_1_DESC.get(), Lang.GUI_DECREASE_10_DESC.get()).setAction(action -> {
            int amountToRemove;
            action.setCancelled(true);
            if (!this.territoryData.doesPlayerHavePermission(tanPlayer, RolePermission.MANAGE_TAXES)) {
                TanChatUtils.message(player, Lang.PLAYER_NO_PERMISSION.get(lang, new String[0]));
                return;
            }
            double currentTax = this.territoryData.getTax();
            int n = amountToRemove = action.isShiftClick() && currentTax > 9.0 ? 10 : 1;
            if (currentTax <= 0.0) {
                TanChatUtils.message(player, Lang.GUI_TREASURY_CANT_TAX_LESS.get(lang, new String[0]));
                return;
            }
            SoundUtil.playSound((Player)player, (SoundEnum)SoundEnum.REMOVE);
            this.territoryData.addToTax(-amountToRemove);
            new TreasuryMenu(player, this.territoryData);
        }).asGuiItem(player, lang);
    }

    @Override
    public boolean isRecurrent() {
        return true;
    }
}

