/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.dataclass.territory.economy;

import dev.triumphteam.gui.guis.Gui;
import org.bukkit.entity.Player;
import org.leralix.tan.dataclass.RankData;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.dataclass.territory.economy.ProfitLine;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.gui.cosmetic.IconManager;
import org.leralix.tan.gui.user.territory.TreasuryMenu;
import org.leralix.tan.gui.user.territory.history.TerritoryTransactionHistory;
import org.leralix.tan.lang.FilledLang;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.storage.database.transactions.TransactionType;
import org.leralix.tan.utils.text.StringUtil;

public class SalaryPaymentLine
extends ProfitLine {
    double totalSalaries = 0.0;

    public SalaryPaymentLine(TerritoryData territoryData) {
        super(territoryData);
        for (RankData rankData : territoryData.getAllRanks()) {
            this.totalSalaries -= (double)(rankData.getSalary() * rankData.getPlayersID().size());
        }
    }

    @Override
    protected double getMoney() {
        return this.totalSalaries;
    }

    @Override
    public FilledLang getLine() {
        return Lang.PLAYER_SALARY_LINE.get(StringUtil.getColoredMoney(this.getMoney()));
    }

    @Override
    public void addItems(Gui gui, Player player, LangType lang) {
        gui.setItem(2, 6, IconManager.getInstance().get(IconKey.SALARY_INFO_ICON).setName(Lang.GUI_TREASURY_SALARY_HISTORY.get(lang, new String[0])).setDescription(Lang.GUI_TREASURY_SALARY_HISTORY_DESC1.get(StringUtil.getColoredMoney(this.getMoney())), Lang.GUI_GENERIC_CLICK_TO_OPEN_HISTORY.get()).setAction(action -> new TerritoryTransactionHistory(player, this.territoryData, TransactionType.SALARY, p -> new TreasuryMenu(player, this.territoryData))).asGuiItem(player, lang));
    }

    @Override
    public boolean isRecurrent() {
        return true;
    }
}

