/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.economy;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.ServicePriority;
import org.leralix.tan.TownsAndNations;
import org.leralix.tan.economy.EconomyUtil;
import org.leralix.tan.economy.TanEconomyExternal;
import org.leralix.tan.economy.TanEconomyStandalone;
import org.leralix.tan.economy.TanEconomyVault;
import org.leralix.tan.utils.constants.Constants;

public class VaultManager {
    public static void setupVault() {
        Logger logger = Bukkit.getLogger();
        if (Constants.useStandaloneEconomy()) {
            TanEconomyVault tanEconomyVault = new TanEconomyVault();
            EconomyUtil.register(tanEconomyVault);
            Bukkit.getServicesManager().register(Economy.class, (Object)tanEconomyVault, (Plugin)TownsAndNations.getPlugin(), ServicePriority.Normal);
            logger.log(Level.INFO, "[TaN] -Vault is detected, registering TaN Economy");
        } else {
            RegisteredServiceProvider rsp = Bukkit.getServer().getServicesManager().getRegistration(Economy.class);
            if (rsp == null) {
                logger.log(Level.INFO, "[TaN] -No active vault economy. Running standalone and waiting for potential update");
                EconomyUtil.register(new TanEconomyStandalone());
                return;
            }
            TanEconomyExternal tanEcon = new TanEconomyExternal((Economy)rsp.getProvider());
            EconomyUtil.register(tanEcon);
            logger.log(Level.INFO, "[TaN] -Vault is detected, using {0} as economy", ((Economy)rsp.getProvider()).getName());
        }
    }
}

