/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.events.newsletter.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import javax.sql.DataSource;
import org.leralix.tan.events.newsletter.dao.NewsletterSubDAO;
import org.leralix.tan.events.newsletter.news.LandmarkClaimedNewsletter;

public class LandmarkClaimedDAO
extends NewsletterSubDAO<LandmarkClaimedNewsletter> {
    private static final String TABLE_NAME = "landmark_claimed_newsletter";

    public LandmarkClaimedDAO(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    protected void createTableIfNotExists() {
        String sql = "CREATE TABLE IF NOT EXISTS landmark_claimed_newsletter (id VARCHAR(36) PRIMARY KEY, landmarkID VARCHAR(36) NOT NULL, newOwnerID VARCHAR(36) NOT NULL )";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to create landmark_claimed_newsletter", e);
        }
    }

    @Override
    public void save(LandmarkClaimedNewsletter newsletter, Connection conn) throws SQLException {
        String sql = "INSERT INTO landmark_claimed_newsletter (id, landmarkID, newOwnerID) VALUES (?, ?, ?)";
        try (PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setObject(1, newsletter.getId());
            ps.setString(2, newsletter.getLandmarkID());
            ps.setString(3, newsletter.getNewOwnerID());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to save diplomacy proposal newsletter", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public LandmarkClaimedNewsletter load(UUID id, long date, Connection conn) throws SQLException {
        String sql = "SELECT landmarkID, newOwnerID FROM landmark_claimed_newsletter WHERE id = ?";
        try (PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setObject(1, id);
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return null;
                String landmarkID = rs.getString("landmarkID");
                String newOwnerID = rs.getString("newOwnerID");
                LandmarkClaimedNewsletter landmarkClaimedNewsletter = new LandmarkClaimedNewsletter(id, date, landmarkID, newOwnerID);
                return landmarkClaimedNewsletter;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to load diplomacy proposal newsletter", e);
        }
    }

    @Override
    public void delete(UUID uuid) {
        String sql = "DELETE FROM landmark_claimed_newsletter WHERE id = ?";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setObject(1, uuid);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to delete from table landmark_claimed_newsletter", e);
        }
    }
}

