/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.events.newsletter.news;

import dev.triumphteam.gui.guis.GuiItem;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.entity.Player;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.dataclass.territory.RegionData;
import org.leralix.tan.events.newsletter.NewsletterType;
import org.leralix.tan.events.newsletter.news.Newsletter;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.gui.cosmetic.IconManager;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.storage.stored.PlayerDataStorage;
import org.leralix.tan.storage.stored.RegionDataStorage;
import org.leralix.tan.utils.text.DateUtil;
import org.leralix.tan.utils.text.TanChatUtils;
import org.tan.api.interfaces.TanPlayer;
import org.tan.api.interfaces.TanRegion;

public class RegionCreationNews
extends Newsletter {
    private final String playerID;
    private final String regionID;

    public RegionCreationNews(TanRegion regionData, TanPlayer player) {
        this.playerID = player.getUUID().toString();
        this.regionID = regionData.getID();
    }

    public RegionCreationNews(UUID id, long date, String playerID, String regionID) {
        super(id, date);
        this.playerID = playerID;
        this.regionID = regionID;
    }

    @Override
    public NewsletterType getType() {
        return NewsletterType.REGION_CREATED;
    }

    public String getPlayerID() {
        return this.playerID;
    }

    public String getRegionID() {
        return this.regionID;
    }

    @Override
    public void broadcast(Player player) {
        ITanPlayer tanPlayer = PlayerDataStorage.getInstance().get(this.playerID);
        if (tanPlayer == null) {
            return;
        }
        RegionData regionData = (RegionData)RegionDataStorage.getInstance().get(this.regionID);
        if (regionData == null) {
            return;
        }
        TanChatUtils.message(player, Lang.REGION_CREATED_NEWSLETTER.get(player, tanPlayer.getNameStored(), regionData.getBaseColoredName()));
    }

    @Override
    public void broadcastConcerned(Player player) {
        this.broadcast(player);
    }

    @Override
    public GuiItem createGuiItem(Player player, LangType lang, Consumer<Player> onClick) {
        ITanPlayer tanPlayer = PlayerDataStorage.getInstance().get(this.playerID);
        if (tanPlayer == null) {
            return null;
        }
        RegionData regionData = (RegionData)RegionDataStorage.getInstance().get(this.regionID);
        if (regionData == null) {
            return null;
        }
        return IconManager.getInstance().get(IconKey.REGION_BASE_ICON).setName(Lang.REGION_CREATED_NEWSLETTER_TITLE.get(lang, new String[0])).setDescription(Lang.NEWSLETTER_DATE.get(DateUtil.getRelativeTimeDescription(lang, this.getDate())), Lang.REGION_CREATED_NEWSLETTER.get(tanPlayer.getNameStored(), regionData.getBaseColoredName()), Lang.NEWSLETTER_RIGHT_CLICK_TO_MARK_AS_READ.get()).setAction(action -> {
            action.setCancelled(true);
            if (action.isRightClick()) {
                this.markAsRead(player);
                onClick.accept(player);
            }
        }).asGuiItem(player, lang);
    }

    @Override
    public GuiItem createConcernedGuiItem(Player player, LangType lang, Consumer<Player> onClick) {
        return this.createGuiItem(player, lang, onClick);
    }

    @Override
    public boolean shouldShowToPlayer(Player player) {
        return true;
    }
}

