/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.admin;

import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.economy.EconomyUtil;
import org.leralix.tan.gui.IteratorGUI;
import org.leralix.tan.gui.admin.AdminMainMenu;
import org.leralix.tan.gui.admin.AdminManagePlayer;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.storage.stored.PlayerDataStorage;
import org.leralix.tan.utils.text.StringUtil;

public class AdminBrowsePlayers
extends IteratorGUI {
    public AdminBrowsePlayers(Player player) {
        super(player, Lang.HEADER_ADMIN_PLAYER_MENU, 6);
        this.open();
    }

    @Override
    public void open() {
        this.iterator(this.getPlayers(), p -> new AdminMainMenu(this.player));
        this.gui.open((HumanEntity)this.player);
    }

    private List<GuiItem> getPlayers() {
        ArrayList<GuiItem> guiItems = new ArrayList<GuiItem>();
        for (ITanPlayer tanPlayer : PlayerDataStorage.getInstance().getAll().values()) {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(tanPlayer.getID()));
            guiItems.add(this.iconManager.get(offlinePlayer).setName(offlinePlayer.getName()).setDescription(Lang.GUI_YOUR_BALANCE_DESC1.get(StringUtil.formatMoney(EconomyUtil.getBalance(offlinePlayer)))).setAction(action -> new AdminManagePlayer(this.player, tanPlayer)).asGuiItem(this.player, this.langType));
        }
        return guiItems;
    }
}

