/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.admin;

import dev.triumphteam.gui.guis.GuiItem;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.leralix.tan.dataclass.territory.RegionData;
import org.leralix.tan.gui.admin.AdminBrowseRegion;
import org.leralix.tan.gui.admin.AdminManageTerritory;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.gui.user.territory.RegionChangeOwnership;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.utils.deprecated.GuiUtil;

public class AdminManageRegion
extends AdminManageTerritory {
    private final RegionData regionData;

    public AdminManageRegion(Player player, RegionData regionData) {
        super(player, Lang.HEADER_ADMIN_SPECIFIC_REGION_MENU.get(regionData.getName()), 3, regionData);
        this.regionData = regionData;
        this.open();
    }

    @Override
    public void open() {
        this.gui.setItem(2, 2, this.getRenameTerritory());
        this.gui.setItem(2, 3, this.getChangeDescription());
        this.gui.setItem(2, 4, this.changeLeader());
        this.gui.setItem(2, 6, this.getTransactionHistory());
        this.gui.setItem(2, 7, this.getDelete());
        this.gui.setItem(3, 1, GuiUtil.createBackArrow(this.player, p -> new AdminBrowseRegion(this.player)));
        this.gui.open((HumanEntity)this.player);
    }

    @NotNull
    private GuiItem changeLeader() {
        return this.iconManager.get(IconKey.REGION_CHANGE_OWNERSHIP_ICON).setName(Lang.GUI_REGION_CHANGE_CAPITAL.get(this.langType, new String[0])).setDescription(Lang.GUI_REGION_CHANGE_CAPITAL_DESC1.get(this.regionData.getCapital().getColoredName())).setClickToAcceptMessage(Lang.GUI_REGION_CHANGE_CAPITAL_DESC2).setAction(action -> new RegionChangeOwnership(this.player, this.regionData)).asGuiItem(this.player, this.langType);
    }
}

