/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.admin;

import dev.triumphteam.gui.guis.GuiItem;
import org.bukkit.entity.Player;
import org.leralix.lib.data.SoundEnum;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.gui.BasicGui;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.gui.user.territory.history.TerritoryTransactionHistory;
import org.leralix.tan.lang.FilledLang;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.listeners.chat.PlayerChatListenerStorage;
import org.leralix.tan.listeners.chat.events.ChangeTerritoryDescription;
import org.leralix.tan.listeners.chat.events.ChangeTerritoryName;
import org.leralix.tan.storage.stored.WarStorage;
import org.leralix.tan.utils.file.FileUtil;
import org.leralix.tan.utils.text.TanChatUtils;

public abstract class AdminManageTerritory
extends BasicGui {
    protected final TerritoryData territoryData;

    protected AdminManageTerritory(Player player, FilledLang menuName, int nbRows, TerritoryData territoryData) {
        super(player, menuName, nbRows);
        this.territoryData = territoryData;
    }

    protected GuiItem getRenameTerritory() {
        return this.iconManager.get(IconKey.TERRITORY_RENAME_ICON).setName(Lang.GUI_SETTINGS_CHANGE_TERRITORY_NAME.get(this.tanPlayer)).setDescription(Lang.GUI_SETTINGS_CHANGE_TERRITORY_NAME_DESC1.get(this.territoryData.getName())).setClickToAcceptMessage(Lang.GUI_GENERIC_CLICK_TO_MODIFY).setAction(action -> {
            TanChatUtils.message(this.player, Lang.ENTER_NEW_VALUE.get(this.player));
            PlayerChatListenerStorage.register(this.player, new ChangeTerritoryName(this.territoryData, 0, p -> this.open()));
        }).asGuiItem(this.player, this.langType);
    }

    protected GuiItem getChangeDescription() {
        return this.iconManager.get(IconKey.TERRITORY_DESCRIPTION_ICON).setName(Lang.GUI_SETTINGS_CHANGE_TOWN_MESSAGE.get(this.tanPlayer)).setDescription(Lang.GUI_SETTINGS_CHANGE_TOWN_MESSAGE_DESC1.get(this.territoryData.getDescription())).setClickToAcceptMessage(Lang.GUI_GENERIC_CLICK_TO_MODIFY).setAction(action -> {
            TanChatUtils.message(this.player, Lang.ENTER_NEW_VALUE.get(this.tanPlayer));
            PlayerChatListenerStorage.register(this.player, new ChangeTerritoryDescription(this.territoryData, p -> this.open()));
        }).asGuiItem(this.player, this.langType);
    }

    protected GuiItem getDelete() {
        return this.iconManager.get(IconKey.TOWN_DELETE_TOWN_ICON).setName(Lang.ADMIN_GUI_DELETE_TERRITORY.get(this.langType, new String[0])).setDescription(Lang.ADMIN_GUI_DELETE_TERRITORY_DESC1.get(this.territoryData.getColoredName())).setAction(action -> {
            FileUtil.addLineToHistory(Lang.REGION_DELETED_NEWSLETTER.get(this.player.getName(), this.territoryData.getName()));
            if (this.territoryData.isCapital()) {
                this.territoryData.getOverlord().ifPresent(overlord -> TanChatUtils.message(this.player, Lang.CANNOT_DELETE_TERRITORY_IF_CAPITAL.get(this.langType, overlord.getBaseColoredName()), SoundEnum.NOT_ALLOWED));
                return;
            }
            if (!WarStorage.getInstance().getWarsOfTerritory(this.territoryData).isEmpty()) {
                TanChatUtils.message(this.player, Lang.CANNOT_DELETE_TERRITORY_IF_AT_WAR.get(this.langType, new String[0]), SoundEnum.NOT_ALLOWED);
                return;
            }
            this.territoryData.delete();
            this.player.closeInventory();
        }).asGuiItem(this.player, this.langType);
    }

    protected GuiItem getTransactionHistory() {
        return this.iconManager.get(IconKey.BUDGET_ICON).setName(Lang.ADMIN_GET_TRANSACTION_HISTORY.get(this.langType, new String[0])).setClickToAcceptMessage(Lang.GUI_GENERIC_CLICK_TO_OPEN).setAction(action -> new TerritoryTransactionHistory(this.player, this.territoryData, p -> this.open())).asGuiItem(this.player, this.langType);
    }
}

