/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.admin;

import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.dataclass.territory.TownData;
import org.leralix.tan.gui.admin.AdminBrowseTown;
import org.leralix.tan.gui.admin.AdminManageTerritory;
import org.leralix.tan.gui.admin.AdminSelectNewOverlord;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.gui.user.territory.SelectNewOwnerForTownMenu;
import org.leralix.tan.lang.FilledLang;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.utils.deprecated.GuiUtil;
import org.leralix.tan.utils.text.TanChatUtils;

public class AdminManageTown
extends AdminManageTerritory {
    private final TownData townData;

    public AdminManageTown(Player player, TownData townData) {
        super(player, Lang.HEADER_ADMIN_SPECIFIC_REGION_MENU.get(townData.getName()), 3, townData);
        this.townData = townData;
        this.open();
    }

    @Override
    public void open() {
        this.gui.setItem(2, 2, this.getRenameTerritory());
        this.gui.setItem(2, 3, this.getChangeDescription());
        this.gui.setItem(2, 4, this.changeLeader());
        this.gui.setItem(2, 5, this.getChangeRegion());
        this.gui.setItem(2, 6, this.getTransactionHistory());
        this.gui.setItem(2, 8, this.getDelete());
        this.gui.setItem(3, 1, GuiUtil.createBackArrow(this.player, p -> new AdminBrowseTown(this.player)));
        this.gui.open((HumanEntity)this.player);
    }

    @NotNull
    private GuiItem getChangeRegion() {
        String name = this.townData.getOverlord().map(TerritoryData::getName).orElseGet(() -> Lang.NO_REGION.get(this.langType, new String[0]));
        ArrayList<Lang> description = new ArrayList<Lang>();
        if (this.townData.haveOverlord()) {
            if (this.townData.isCapital()) {
                description.add(Lang.GUI_CANNOT_QUIT_IF_LEADER);
            } else {
                description.add(Lang.GUI_RIGHT_CLICK_TO_QUIT);
            }
        } else {
            description.add(Lang.GUI_LEFT_CLICK_TO_SET_REGION);
        }
        return this.iconManager.get(IconKey.REGION_BASE_ICON).setName(name).setDescription(new FilledLang[0]).setClickToAcceptMessage(description).setAction(action -> {
            if (this.townData.haveOverlord()) {
                if (this.townData.isCapital()) {
                    TanChatUtils.message(this.player, Lang.GUI_CANNOT_QUIT_IF_LEADER.get(this.langType, new String[0]));
                } else {
                    this.townData.removeOverlord();
                    this.open();
                }
            } else {
                new AdminSelectNewOverlord(this.player, this.townData);
            }
        }).asGuiItem(this.player, this.langType);
    }

    @NotNull
    private GuiItem changeLeader() {
        return this.iconManager.get(IconKey.TOWN_CHANGE_OWNERSHIP_ICON).setName(Lang.GUI_TOWN_SETTINGS_TRANSFER_OWNERSHIP.get(this.langType, new String[0])).setDescription(Lang.GUI_TOWN_SETTINGS_TRANSFER_OWNERSHIP_DESC1.get(this.townData.getLeaderData().getNameStored())).setClickToAcceptMessage(Lang.GUI_REGION_CHANGE_CAPITAL_DESC2).setAction(action -> new SelectNewOwnerForTownMenu(this.player, this.townData, this::open)).asGuiItem(this.player, this.langType);
    }
}

