/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.admin;

import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.leralix.tan.gui.IteratorGUI;
import org.leralix.tan.gui.admin.AdminMainMenu;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.storage.stored.WarStorage;
import org.leralix.tan.war.PlannedAttack;
import org.leralix.tan.war.info.AttackResultCancelled;

public class AdminWarMenu
extends IteratorGUI {
    private final Collection<PlannedAttack> plannedAttackList = WarStorage.getInstance().getAllAttacks();

    public AdminWarMenu(Player player) {
        super(player, Lang.HEADER_ADMIN_WAR_MENU, 6);
        this.open();
    }

    @Override
    public void open() {
        this.iterator(this.getWars(), p -> new AdminMainMenu(this.player));
        this.gui.open((HumanEntity)this.player);
    }

    private List<GuiItem> getWars() {
        ArrayList<GuiItem> res = new ArrayList<GuiItem>();
        for (PlannedAttack plannedAttack : this.plannedAttackList) {
            res.add(plannedAttack.getAdminIcon(this.iconManager, this.langType, this.tanPlayer.getTimeZone()).setAction(action -> {
                if (!plannedAttack.isAdminApproved()) {
                    if (action.isLeftClick()) {
                        plannedAttack.setAdminApproved(true);
                    } else if (action.isRightClick()) {
                        plannedAttack.end(new AttackResultCancelled());
                    }
                }
                this.open();
            }).asGuiItem(this.player, this.langType));
        }
        return res;
    }
}

