/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.common;

import dev.triumphteam.gui.guis.GuiItem;
import java.util.Collections;
import java.util.List;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.leralix.tan.gui.BasicGui;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.lang.FilledLang;
import org.leralix.tan.lang.Lang;

public class ConfirmMenu
extends BasicGui {
    private final List<FilledLang> confirmDescription;
    private final Runnable confirmAction;
    private final Runnable cancelAction;

    public ConfirmMenu(Player player, FilledLang confirmDescription, Runnable confirmAction, Runnable cancelAction) {
        this(player, Collections.singletonList(confirmDescription), confirmAction, cancelAction);
    }

    public ConfirmMenu(Player player, List<FilledLang> confirmDescription, Runnable confirmAction, Runnable cancelAction) {
        super(player, Lang.HEADER_CONFIRMATION, 3);
        this.confirmDescription = confirmDescription;
        this.confirmAction = confirmAction;
        this.cancelAction = cancelAction;
        this.open();
    }

    @Override
    public void open() {
        this.gui.setItem(2, 4, this.getConfirmButton());
        this.gui.setItem(2, 6, this.getCancelButton());
        this.gui.open((HumanEntity)this.player);
    }

    @NotNull
    private GuiItem getCancelButton() {
        return this.iconManager.get(IconKey.CANCEL_ICON).setName(Lang.GENERIC_CANCEL_ACTION.get(this.tanPlayer)).setAction(action -> this.cancelAction.run()).asGuiItem(this.player, this.langType);
    }

    @NotNull
    private GuiItem getConfirmButton() {
        return this.iconManager.get(IconKey.CONFIRM_ICON).setName(Lang.GENERIC_CONFIRM_ACTION.get(this.tanPlayer)).setDescription(this.confirmDescription).setAction(action -> this.confirmAction.run()).asGuiItem(this.player, this.langType);
    }
}

