/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.cosmetic.type;

import dev.triumphteam.gui.builder.item.ItemBuilder;
import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.leralix.lib.data.SoundEnum;
import org.leralix.tan.gui.cosmetic.type.IconType;
import org.leralix.tan.gui.cosmetic.type.ItemIconBuilder;
import org.leralix.tan.gui.service.Requirements;
import org.leralix.tan.gui.service.requirements.IndividualRequirement;
import org.leralix.tan.lang.FilledLang;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.utils.text.TanChatUtils;

public class IconBuilder {
    private String name;
    private final List<FilledLang> description = new ArrayList<FilledLang>();
    private final Requirements requirements = new Requirements();
    private Consumer<InventoryClickEvent> action;
    private boolean hideItemFlags = false;
    private final IconType menuIcon;
    private boolean hidePrerequisites;
    private final List<Lang> clickForActionMessage = new ArrayList<Lang>();

    public IconBuilder(IconType menuIcon) {
        this.clickForActionMessage.add(Lang.GUI_GENERIC_CLICK_TO_OPEN);
        this.hidePrerequisites = false;
        this.menuIcon = menuIcon == null ? new ItemIconBuilder(Material.BARRIER) : menuIcon;
    }

    public IconBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public IconBuilder addDescription(FilledLang ... descriptions) {
        return this.addDescription(List.of(descriptions));
    }

    public IconBuilder addDescription(Collection<FilledLang> description) {
        this.description.addAll(description);
        return this;
    }

    public IconBuilder setDescription(FilledLang ... descriptions) {
        return this.setDescription(List.of(descriptions));
    }

    public IconBuilder setDescription(Collection<FilledLang> description) {
        this.description.clear();
        this.description.addAll(description);
        return this;
    }

    public IconBuilder setRequirements(IndividualRequirement ... requirements) {
        return this.setRequirements(List.of(requirements));
    }

    public IconBuilder setRequirements(Collection<IndividualRequirement> requirements) {
        this.requirements.add(requirements);
        return this;
    }

    public IconBuilder setClickToAcceptMessage(Lang ... messages) {
        return this.setClickToAcceptMessage(List.of(messages));
    }

    public IconBuilder setClickToAcceptMessage(Collection<Lang> messages) {
        this.clickForActionMessage.clear();
        this.clickForActionMessage.addAll(messages);
        return this;
    }

    public IconBuilder setAction(Consumer<InventoryClickEvent> action) {
        this.action = action;
        return this;
    }

    public IconBuilder setHideItemFlags(boolean hideItemFlags) {
        this.hideItemFlags = hideItemFlags;
        return this;
    }

    public IconBuilder hidePrerequisite(boolean hidePrerequisites) {
        this.hidePrerequisites = hidePrerequisites;
        return this;
    }

    public GuiItem asGuiItem(Player player, LangType langType) {
        ItemStack item = this.menuIcon.getItemStack(player);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(this.name);
            meta.setLore(this.generateDescription(langType));
            if (this.hideItemFlags) {
                meta.getItemFlags().add(ItemFlag.HIDE_ATTRIBUTES);
                meta.getItemFlags().add(ItemFlag.HIDE_ENCHANTS);
                meta.getItemFlags().add(ItemFlag.HIDE_UNBREAKABLE);
                meta.getItemFlags().add(ItemFlag.HIDE_PLACED_ON);
                meta.getItemFlags().add(ItemFlag.HIDE_DYE);
            }
            item.setItemMeta(meta);
        }
        if (this.action == null) {
            return ItemBuilder.from(item).asGuiItem(event -> event.setCancelled(true));
        }
        return ItemBuilder.from(item).asGuiItem(event -> {
            if (this.requirements.isInvalid()) {
                TanChatUtils.message(player, Lang.GUI_TOWN_LEVEL_UP_UNI_REQ_NOT_MET.get(langType, new String[0]), SoundEnum.NOT_ALLOWED);
                return;
            }
            this.requirements.actionConsume();
            this.action.accept((InventoryClickEvent)event);
        });
    }

    private List<String> generateDescription(LangType langType) {
        ArrayList<String> res = new ArrayList<String>();
        for (FilledLang filledLang : this.description) {
            res.add(filledLang.get(langType));
        }
        if (!this.hidePrerequisites && this.action != null && !this.requirements.isEmpty()) {
            res.add("");
            res.addAll(this.requirements.getRequirementsParagraph(langType));
        }
        if (this.action != null) {
            res.add("");
            for (Lang messages : this.clickForActionMessage) {
                res.add(messages.get(langType, new String[0]));
            }
        }
        return res;
    }
}

