/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.landmark;

import dev.triumphteam.gui.builder.item.ItemBuilder;
import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.leralix.lib.data.SoundEnum;
import org.leralix.lib.utils.SoundUtil;
import org.leralix.tan.dataclass.Landmark;
import org.leralix.tan.dataclass.territory.TownData;
import org.leralix.tan.enums.RolePermission;
import org.leralix.tan.gui.BasicGui;
import org.leralix.tan.gui.common.ConfirmMenu;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.gui.legacy.PlayerGUI;
import org.leralix.tan.gui.service.requirements.RankPermissionRequirement;
import org.leralix.tan.lang.FilledLang;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.storage.stored.LandmarkStorage;
import org.leralix.tan.storage.stored.TownDataStorage;
import org.leralix.tan.upgrade.rewards.numeric.LandmarkCap;
import org.leralix.tan.utils.constants.Constants;
import org.leralix.tan.utils.deprecated.GuiUtil;
import org.leralix.tan.utils.deprecated.HeadUtils;

public class LandmarkNoOwnerMenu
extends BasicGui {
    private final Landmark landmark;

    public LandmarkNoOwnerMenu(Player player, Landmark landmark) {
        super(player, Lang.HEADER_LANDMARK_UNCLAIMED, 3);
        this.landmark = landmark;
        this.open();
    }

    @Override
    public void open() {
        this.gui.setItem(1, 5, this.getLandmarkIcon(this.landmark));
        this.gui.setItem(2, 5, this.getClaimButton());
        this.gui.setItem(3, 1, GuiUtil.createBackArrow(this.player, HumanEntity::closeInventory));
        GuiItem panelGui = ItemBuilder.from(HeadUtils.createCustomItemStack(Material.GRAY_STAINED_GLASS_PANE, "", new String[0])).asGuiItem(event -> event.setCancelled(true));
        this.gui.getFiller().fillBottom(panelGui);
        this.gui.open((HumanEntity)this.player);
    }

    @NotNull
    private GuiItem getLandmarkIcon(Landmark landmark) {
        LangType lang = this.tanPlayer.getLang();
        return ItemBuilder.from(landmark.getIcon(lang)).asGuiItem(event -> event.setCancelled(true));
    }

    @NotNull
    private GuiItem getClaimButton() {
        int currentLandmarkCount;
        TownData playerTown = TownDataStorage.getInstance().get(this.player);
        double cost = Constants.getClaimLandmarkCost();
        ArrayList<FilledLang> description = new ArrayList<FilledLang>();
        if (cost > 0.0) {
            description.add(Lang.GUI_LANDMARK_CLAIM_COST.get(String.valueOf(cost)));
        }
        boolean isRequirementsMet = true;
        LandmarkCap landmarkCap = playerTown.getNewLevel().getStat(LandmarkCap.class);
        if (!landmarkCap.canDoAction(currentLandmarkCount = LandmarkStorage.getInstance().getLandmarkOf(playerTown).size())) {
            isRequirementsMet = false;
            description.add(Lang.GUI_LANDMARK_TOWN_FULL.get());
        }
        if (Constants.isLandmarkClaimRequiresEncirclement() && !this.landmark.isEncircledBy(playerTown)) {
            isRequirementsMet = false;
            description.add(Lang.GUI_LANDMARK_NOT_ENCIRCLED.get());
        }
        if (cost > playerTown.getBalance()) {
            isRequirementsMet = false;
            description.add(Lang.GUI_LANDMARK_NOT_ENOUGH_MONEY.get(Double.toString(Constants.getClaimLandmarkCost())));
        }
        IconKey iconKey = isRequirementsMet ? IconKey.GUI_CONFIRM_CLAIM_LANDMARK_REQUIREMENTS_MET_ICON : IconKey.GUI_CONFIRM_CLAIM_LANDMARK_REQUIREMENTS_UNMET_ICON;
        boolean requirementMet = isRequirementsMet;
        return this.iconManager.get(iconKey).setName(Lang.GUI_TOWN_RELATION_ADD_TOWN.get(this.tanPlayer)).setDescription(description).setClickToAcceptMessage(Lang.GUI_LANDMARK_LEFT_CLICK_TO_CLAIM).setRequirements(new RankPermissionRequirement(playerTown, this.tanPlayer, RolePermission.MANAGE_LANDMARK)).setAction(event -> {
            if (!requirementMet) {
                SoundUtil.playSound((Player)this.player, (SoundEnum)SoundEnum.NOT_ALLOWED);
                return;
            }
            double actualBalance = playerTown.getBalance();
            double newBalance = actualBalance - cost;
            new ConfirmMenu(this.player, Lang.GUI_GENERIC_NEW_BALANCE_MENU.get(Double.toString(actualBalance), Double.toString(newBalance)), () -> {
                playerTown.removeFromBalance(cost);
                this.landmark.setOwner(playerTown);
                playerTown.broadcastMessageWithSound(Lang.GUI_LANDMARK_CLAIMED.get(), SoundEnum.GOOD);
                PlayerGUI.dispatchLandmarkGui(this.player, this.landmark);
            }, this::open);
        }).asGuiItem(this.player, this.langType);
    }
}

