/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.landmark;

import dev.triumphteam.gui.guis.GuiItem;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.leralix.lib.data.SoundEnum;
import org.leralix.lib.utils.SoundUtil;
import org.leralix.tan.dataclass.Landmark;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.dataclass.territory.TownData;
import org.leralix.tan.enums.RolePermission;
import org.leralix.tan.gui.BasicGui;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.gui.service.requirements.RankPermissionRequirement;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.utils.deprecated.GuiUtil;
import org.leralix.tan.utils.text.TanChatUtils;

public class LandmarkOwnedMenu
extends BasicGui {
    private final TerritoryData territoryData;
    private final Landmark landmark;

    public LandmarkOwnedMenu(Player player, TownData townData, Landmark landmark) {
        super(player, Lang.HEADER_LANDMARK_CLAIMED.get(townData.getName()), 3);
        this.territoryData = townData;
        this.landmark = landmark;
        this.open();
    }

    @Override
    public void open() {
        GuiItem landmarkIcon = this.iconManager.get(this.landmark.getIcon(this.langType)).asGuiItem(this.player, this.langType);
        this.gui.setItem(1, 5, landmarkIcon);
        this.gui.setItem(2, 4, this.getCollectButton());
        this.gui.setItem(2, 6, this.getAbandonButton());
        this.gui.setItem(3, 1, GuiUtil.createBackArrow(this.player, HumanEntity::closeInventory));
        GuiItem panelIcon = GuiUtil.getUnnamedItem(Material.GRAY_STAINED_GLASS_PANE);
        this.gui.getFiller().fillTop(panelIcon);
        this.gui.getFiller().fillBottom(panelIcon);
        this.gui.open((HumanEntity)this.player);
    }

    @NotNull
    private GuiItem getAbandonButton() {
        return this.iconManager.get(IconKey.GUI_LANDMARK_ABANDON_LANDMARK).setName(Lang.GUI_REMOVE_LANDMARK.get(this.tanPlayer)).setRequirements(new RankPermissionRequirement(this.territoryData, this.tanPlayer, RolePermission.MANAGE_LANDMARK)).setAction(action -> {
            this.landmark.removeOwnership();
            SoundUtil.playSound((Player)this.player, (SoundEnum)SoundEnum.MINOR_GOOD);
            this.player.closeInventory();
        }).asGuiItem(this.player, this.langType);
    }

    private GuiItem getCollectButton() {
        int quantity = this.landmark.computeStoredReward(this.territoryData);
        return this.iconManager.get(quantity == 0 ? IconKey.GUI_LANDMARK_COLLECT_REWARDS_EMPTY : IconKey.GUI_LANDMARK_COLLECT_REWARDS).setName(Lang.GUI_COLLECT_LANDMARK.get(this.langType, new String[0])).setDescription(Lang.GUI_COLLECT_LANDMARK_DESC2.get(Integer.toString(quantity))).setRequirements(new RankPermissionRequirement(this.territoryData, this.tanPlayer, RolePermission.COLLECT_LANDMARK)).setClickToAcceptMessage(Lang.GUI_GENERIC_CLICK_TO_PROCEED).setAction(action -> {
            if (quantity == 0) {
                SoundUtil.playSound((Player)this.player, (SoundEnum)SoundEnum.NOT_ALLOWED);
                return;
            }
            this.landmark.giveToPlayer(this.player, quantity);
            TanChatUtils.message(this.player, Lang.GUI_LANDMARK_REWARD_COLLECTED.get(this.tanPlayer, Integer.toString(quantity)), SoundEnum.GOOD);
            this.open();
        }).asGuiItem(this.player, this.langType);
    }
}

