/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.player;

import dev.triumphteam.gui.guis.GuiItem;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.leralix.tan.economy.EconomyUtil;
import org.leralix.tan.events.newsletter.NewsletterStorage;
import org.leralix.tan.gui.BasicGui;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.gui.cosmetic.IconManager;
import org.leralix.tan.gui.user.MainMenu;
import org.leralix.tan.gui.user.player.LangMenu;
import org.leralix.tan.gui.user.player.NewsletterMenu;
import org.leralix.tan.gui.user.player.PlayerSelectTimezoneMenu;
import org.leralix.tan.gui.user.property.PlayerPropertiesMenu;
import org.leralix.tan.gui.user.territory.history.PlayerTransactionHistory;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.timezone.TimeZoneManager;
import org.leralix.tan.utils.deprecated.GuiUtil;

public class PlayerMenu
extends BasicGui {
    public PlayerMenu(Player player) {
        super(player, Lang.HEADER_PLAYER_PROFILE, 3);
        this.open();
    }

    @Override
    public void open() {
        this.gui.setItem(1, 5, this.getPlayerHeadIcon());
        this.gui.setItem(2, 2, this.getBalanceButton());
        this.gui.setItem(2, 3, this.getPropertyButton());
        this.gui.setItem(2, 4, this.getNewsletterButton());
        this.gui.setItem(2, 6, this.getTransactionHistory());
        this.gui.setItem(2, 7, this.getTimezoneButton());
        this.gui.setItem(2, 8, this.getLanguageButton());
        this.gui.setItem(3, 1, GuiUtil.createBackArrow(this.player, MainMenu::new));
        this.gui.open((HumanEntity)this.player);
    }

    private GuiItem getPlayerHeadIcon() {
        return IconManager.getInstance().get(IconKey.PLAYER_HEAD_ICON).setName(Lang.GUI_PLAYER_ICON.get(this.tanPlayer, this.player.getName())).asGuiItem(this.player, this.langType);
    }

    private GuiItem getBalanceButton() {
        return IconManager.getInstance().get(IconKey.PLAYER_BALANCE_ICON).setName(Lang.GUI_YOUR_BALANCE.get(this.langType, this.player.getName())).setDescription(Lang.GUI_YOUR_BALANCE_DESC1.get(Double.toString(EconomyUtil.getBalance(this.player)))).asGuiItem(this.player, this.langType);
    }

    private GuiItem getPropertyButton() {
        return IconManager.getInstance().get(IconKey.PLAYER_PROPERTY_ICON).setName(Lang.GUI_PLAYER_MANAGE_PROPERTIES.get(this.langType, new String[0])).setDescription(Lang.GUI_PLAYER_MANAGE_PROPERTIES_DESC1.get()).setAction(event -> new PlayerPropertiesMenu(this.player).open()).asGuiItem(this.player, this.langType);
    }

    private GuiItem getNewsletterButton() {
        return IconManager.getInstance().get(IconKey.NEWSLETTER_ICON).setName(Lang.GUI_PLAYER_NEWSLETTER.get(this.tanPlayer)).setDescription(Lang.GUI_PLAYER_NEWSLETTER_DESC1.get(Integer.toString(NewsletterStorage.getInstance().getNbUnreadNewsletterForPlayer(this.player)))).setAction(event -> new NewsletterMenu(this.player).open()).asGuiItem(this.player, this.langType);
    }

    private GuiItem getTimezoneButton() {
        TimeZoneManager timeZoneManager = TimeZoneManager.getInstance();
        return this.iconManager.get(IconKey.TIMEZONE_BUTTON).setName(Lang.GUI_TIMEZONE_BUTTON.get(this.tanPlayer)).setDescription(Lang.GUI_TIMEZONE_BUTTON_SERVER_ZONE.get(timeZoneManager.getTimezoneEnum().getName(this.tanPlayer.getLang())), Lang.GUI_TIMEZONE_BUTTON_PLAYER_ZONE.get(this.tanPlayer.getTimeZone().getName(this.tanPlayer.getLang()))).setAction(p -> new PlayerSelectTimezoneMenu(this.player)).asGuiItem(this.player, this.langType);
    }

    private GuiItem getLanguageButton() {
        LangType serverLang = Lang.getServerLang();
        LangType playerLang = this.tanPlayer.getLang();
        return IconManager.getInstance().get(IconKey.LANGUAGE_ICON).setName(Lang.GUI_LANGUAGE_BUTTON.get(this.tanPlayer)).setDescription(Lang.GUI_LANGUAGE_BUTTON_DESC1.get(serverLang.getName()), Lang.GUI_LANGUAGE_BUTTON_DESC2.get(playerLang.getName())).setAction(event -> new LangMenu(this.player).open()).asGuiItem(this.player, this.langType);
    }

    protected GuiItem getTransactionHistory() {
        return this.iconManager.get(IconKey.MISCELLANEOUS_SPENDING_ICON).setName(Lang.GUI_TREASURY_MISCELLANEOUS_SPENDING.get(this.tanPlayer)).setClickToAcceptMessage(Lang.GUI_GENERIC_CLICK_TO_OPEN_HISTORY).setAction(action -> new PlayerTransactionHistory(this.player, this.tanPlayer, p -> this.open())).asGuiItem(this.player, this.langType);
    }
}

