/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.property;

import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.leralix.lib.data.SoundEnum;
import org.leralix.lib.utils.SoundUtil;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.dataclass.territory.permission.ChunkPermission;
import org.leralix.tan.enums.permissions.ChunkPermissionType;
import org.leralix.tan.gui.IteratorGUI;
import org.leralix.tan.gui.user.property.BrowsePlayerWithPermissionMenu;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.storage.PermissionManager;
import org.leralix.tan.storage.stored.PlayerDataStorage;

public class AddPlayerWithPermissionMenu
extends IteratorGUI {
    private final PermissionManager permissionManager;
    private final ChunkPermissionType chunkPermission;
    private final BrowsePlayerWithPermissionMenu returnMenu;

    public AddPlayerWithPermissionMenu(Player player, PermissionManager permissionManager, ChunkPermissionType chunkPermission, BrowsePlayerWithPermissionMenu browsePlayerWithPermissionMenu) {
        super(player, chunkPermission.getLabel(), 3);
        this.permissionManager = permissionManager;
        this.chunkPermission = chunkPermission;
        this.returnMenu = browsePlayerWithPermissionMenu;
        this.open();
    }

    @Override
    public void open() {
        this.iterator(this.getPlayers(), player -> this.returnMenu.open());
        this.gui.open((HumanEntity)this.player);
    }

    private List<GuiItem> getPlayers() {
        ArrayList<GuiItem> guiItems = new ArrayList<GuiItem>();
        for (Player playerToAdd : Bukkit.getOnlinePlayers()) {
            ITanPlayer playerToAddData = PlayerDataStorage.getInstance().get(playerToAdd);
            ChunkPermission permission = this.permissionManager.get(this.chunkPermission);
            if (permission.isAllowed(this.tanPlayer.getTown(), playerToAddData)) continue;
            guiItems.add(this.iconManager.get((OfflinePlayer)playerToAdd).setName(playerToAdd.getName()).setDescription(Lang.GUI_GENERIC_ADD_BUTTON.get()).setAction(action -> {
                permission.addSpecificPlayerPermission(playerToAdd.getUniqueId().toString());
                SoundUtil.playSound((Player)this.player, (SoundEnum)SoundEnum.ADD);
                this.open();
            }).asGuiItem(this.player, this.langType));
        }
        return guiItems;
    }
}

