/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.property;

import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.leralix.tan.dataclass.PropertyData;
import org.leralix.tan.dataclass.territory.permission.RelationPermission;
import org.leralix.tan.enums.permissions.ChunkPermissionType;
import org.leralix.tan.gui.BasicGui;
import org.leralix.tan.gui.IteratorGUI;
import org.leralix.tan.gui.user.property.BrowsePlayerWithPermissionMenu;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.storage.PermissionManager;

public class PropertyChunkSettingsMenu
extends IteratorGUI {
    private final PropertyData propertyData;
    private final BasicGui returnMenu;

    public PropertyChunkSettingsMenu(Player player, PropertyData propertyData, BasicGui returnGui) {
        super(player, Lang.HEADER_CHUNK_PERMISSION, 4);
        this.propertyData = propertyData;
        this.returnMenu = returnGui;
        this.open();
    }

    @Override
    public void open() {
        this.iterator(this.getChunkPermission(), p -> this.returnMenu.open(), Material.LIME_STAINED_GLASS_PANE);
        this.gui.open((HumanEntity)this.player);
    }

    private List<GuiItem> getChunkPermission() {
        ArrayList<GuiItem> guiItems = new ArrayList<GuiItem>();
        PermissionManager permissionManager = this.propertyData.getPermissionManager();
        for (ChunkPermissionType type : ChunkPermissionType.values()) {
            RelationPermission permission = permissionManager.get(type).getOverallPermission();
            GuiItem item = this.iconManager.get(type.getIconKey()).setName(type.getName().get(this.tanPlayer)).setDescription(Lang.GUI_TOWN_CLAIM_SETTINGS_DESC1.get(permission.getColoredName(this.langType))).setClickToAcceptMessage(Lang.GUI_GENERIC_CLICK_TO_MODIFY, Lang.GUI_RIGHT_CLICK_TO_ADD_SPECIFIC_PLAYER).setAction(event -> {
                event.setCancelled(true);
                if (event.isLeftClick()) {
                    permissionManager.nextPermission(type);
                    this.open();
                } else if (event.isRightClick()) {
                    new BrowsePlayerWithPermissionMenu(this.player, permissionManager, type, this);
                }
            }).asGuiItem(this.player, this.langType);
            guiItems.add(item);
        }
        return guiItems;
    }
}

