/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.property;

import dev.triumphteam.gui.guis.GuiItem;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.leralix.lib.data.SoundEnum;
import org.leralix.tan.dataclass.PropertyData;
import org.leralix.tan.gui.BasicGui;
import org.leralix.tan.gui.common.ConfirmMenu;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.gui.user.property.PropertyChunkSettingsMenu;
import org.leralix.tan.lang.FilledLang;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.listeners.chat.PlayerChatListenerStorage;
import org.leralix.tan.listeners.chat.events.ChangePropertyDescription;
import org.leralix.tan.listeners.chat.events.ChangePropertyName;
import org.leralix.tan.listeners.chat.events.ChangePropertyRentPrice;
import org.leralix.tan.listeners.chat.events.ChangePropertySalePrice;
import org.leralix.tan.utils.text.NumberUtil;
import org.leralix.tan.utils.text.TanChatUtils;

public abstract class PropertyMenus
extends BasicGui {
    protected final PropertyData propertyData;

    protected PropertyMenus(Player player, FilledLang title, int rows, PropertyData propertyData) {
        super(player, title, rows);
        this.propertyData = propertyData;
    }

    protected GuiItem getPropertyIcon() {
        return this.iconManager.get(this.propertyData.getIcon()).setName(this.propertyData.getName()).setDescription(this.propertyData.getBasicDescription()).asGuiItem(this.player, this.langType);
    }

    protected GuiItem getRenameButton() {
        return this.iconManager.get(IconKey.PROPERTY_RENAME_ICON).setName(Lang.GUI_PROPERTY_CHANGE_NAME.get(this.langType, new String[0])).setDescription(Lang.GUI_PROPERTY_CHANGE_NAME_DESC1.get(this.propertyData.getName())).setClickToAcceptMessage(Lang.GUI_GENERIC_CLICK_TO_RENAME).setAction(action -> {
            TanChatUtils.message(this.player, Lang.ENTER_NEW_VALUE.get(this.langType, new String[0]));
            PlayerChatListenerStorage.register(this.player, new ChangePropertyName(this.propertyData, p -> this.open()));
        }).asGuiItem(this.player, this.langType);
    }

    protected GuiItem getDescriptionButton() {
        return this.iconManager.get(IconKey.PROPERTY_DESCRIPTION_ICON).setName(Lang.GUI_PROPERTY_CHANGE_DESCRIPTION.get(this.langType, new String[0])).setDescription(Lang.GUI_PROPERTY_CHANGE_DESCRIPTION_DESC1.get(this.propertyData.getDescription())).setClickToAcceptMessage(Lang.GUI_GENERIC_CLICK_TO_RENAME).setAction(action -> {
            TanChatUtils.message(this.player, Lang.ENTER_NEW_VALUE.get(this.langType, new String[0]));
            PlayerChatListenerStorage.register(this.player, new ChangePropertyDescription(this.propertyData, p -> this.open()));
        }).asGuiItem(this.player, this.langType);
    }

    protected GuiItem getBoundariesButton() {
        return this.iconManager.get(IconKey.PROPERTY_BOUNDS_ICON).setName(Lang.GUI_PROPERTY_DRAWN_BOX.get(this.langType, new String[0])).setClickToAcceptMessage(Lang.GUI_GENERIC_CLICK_TO_SHOW).setAction(action -> {
            this.player.closeInventory();
            this.propertyData.showBox(this.player);
        }).asGuiItem(this.player, this.langType);
    }

    protected GuiItem forSaleButton() {
        IconKey iconKey = this.propertyData.isForSale() ? IconKey.SELL_PROPERTY_ICON_FOR_SALE : IconKey.SELL_PROPERTY_ICON_NOT_FOR_SALE;
        Lang name = this.propertyData.isForSale() ? Lang.GUI_PROPERTY_FOR_SALE : Lang.GUI_PROPERTY_NOT_FOR_SALE;
        double price = this.propertyData.getPrice();
        double total = this.propertyData.getPriceWithTax();
        double taxPrice = total - price;
        return this.iconManager.get(iconKey).setName(name.get(this.langType, new String[0])).setDescription(Lang.GUI_BUYING_PRICE.get(Double.toString(total), Double.toString(price), Double.toString(taxPrice)), Lang.GUI_TOWN_RATE.get(String.format("%.2f", this.propertyData.getTown().getTaxOnBuyingProperty() * 100.0))).setClickToAcceptMessage(Lang.GUI_LEFT_CLICK_TO_SWITCH_SALE, Lang.GUI_RIGHT_CLICK_TO_CHANGE_PRICE).setAction(event -> {
            if (event.getClick() == ClickType.RIGHT) {
                TanChatUtils.message(this.player, Lang.ENTER_NEW_VALUE.get(this.langType, new String[0]));
                PlayerChatListenerStorage.register(this.player, new ChangePropertySalePrice(this.propertyData, p -> this.open()));
            } else if (event.getClick() == ClickType.LEFT) {
                if (this.propertyData.isRented()) {
                    TanChatUtils.message(this.player, Lang.PROPERTY_ALREADY_RENTED.get(this.langType, new String[0]));
                    return;
                }
                this.propertyData.swapIsForSale();
                this.open();
            }
        }).asGuiItem(this.player, this.langType);
    }

    protected GuiItem forRentButton() {
        IconKey iconKey = this.propertyData.isForRent() ? IconKey.RENT_PROPERTY_ICON_FOR_RENT : IconKey.RENT_PROPERTY_ICON_NOT_FOR_RENT;
        Lang name = this.propertyData.isForRent() ? Lang.GUI_PROPERTY_FOR_RENT : Lang.GUI_PROPERTY_NOT_FOR_RENT;
        double price = this.propertyData.getRentPrice();
        double taxPrice = NumberUtil.roundWithDigits(price * this.propertyData.getTown().getTaxOnRentingProperty());
        double total = this.propertyData.getRentPriceWithTax();
        return this.iconManager.get(iconKey).setName(name.get(this.langType, new String[0])).setDescription(Lang.GUI_BUYING_PRICE.get(Double.toString(total), Double.toString(price), Double.toString(taxPrice)), Lang.GUI_TOWN_RATE.get(String.format("%.2f", this.propertyData.getTown().getTaxOnRentingProperty() * 100.0))).setClickToAcceptMessage(Lang.GUI_LEFT_CLICK_TO_SWITCH_SALE, Lang.GUI_RIGHT_CLICK_TO_CHANGE_PRICE).setAction(event -> {
            if (event.getClick() == ClickType.RIGHT) {
                TanChatUtils.message(this.player, Lang.ENTER_NEW_VALUE.get(this.langType, new String[0]));
                PlayerChatListenerStorage.register(this.player, new ChangePropertyRentPrice(this.propertyData, p -> this.open()));
            } else if (event.getClick() == ClickType.LEFT) {
                if (this.propertyData.isRented()) {
                    TanChatUtils.message(this.player, Lang.PROPERTY_ALREADY_RENTED.get(this.langType, new String[0]));
                    return;
                }
                this.propertyData.swapIsRent();
                this.open();
            }
        }).asGuiItem(this.player, this.langType);
    }

    protected GuiItem getDeleteButton() {
        return this.iconManager.get(IconKey.DELETE_PROPERTY_ICON).setName(Lang.GUI_PROPERTY_DELETE_PROPERTY.get(this.langType, new String[0])).setClickToAcceptMessage(Lang.GUI_GENERIC_CLICK_TO_PROCEED).setAction(event -> new ConfirmMenu(this.player, Lang.GUI_PROPERTY_DELETE_PROPERTY_CONFIRM.get(this.propertyData.getName()), () -> {
            this.propertyData.delete();
            this.player.closeInventory();
        }, this::open)).asGuiItem(this.player, this.langType);
    }

    protected GuiItem getAuthorizedPlayersButton() {
        boolean isRentedAndPlayerIsNotRenter = this.propertyData.isRented() && !this.propertyData.getRenter().equals(this.tanPlayer);
        return this.iconManager.get(IconKey.AUTHORIZED_PLAYERS_ICON).setName(Lang.GUI_PROPERTY_PLAYER_LIST.get(this.langType, new String[0])).setClickToAcceptMessage(isRentedAndPlayerIsNotRenter ? Lang.CANNOT_MANAGE_AUTHORIZED_PLAYER_IF_PROPERTY_IS_RENTED : Lang.GUI_GENERIC_CLICK_TO_OPEN).setAction(event -> {
            if (isRentedAndPlayerIsNotRenter) {
                TanChatUtils.message(this.player, Lang.CANNOT_MANAGE_AUTHORIZED_PLAYER_IF_PROPERTY_IS_RENTED.get(this.langType, new String[0]));
                return;
            }
            new PropertyChunkSettingsMenu(this.player, this.propertyData, this);
        }).asGuiItem(this.player, this.langType);
    }

    protected GuiItem getKickRenterButton() {
        return this.iconManager.get(this.propertyData.getOfflineRenter()).setName(Lang.GUI_PROPERTY_RENTED_BY.get(this.langType, this.propertyData.getRenter().getNameStored())).setDescription(Lang.GUI_PROPERTY_RIGHT_CLICK_TO_EXPEL_RENTER.get()).setAction(event -> {
            event.setCancelled(true);
            Player renter = this.propertyData.getRenterPlayer();
            this.propertyData.expelRenter(false);
            TanChatUtils.message(this.player, Lang.PROPERTY_RENTER_EXPELLED_OWNER_SIDE.get(this.langType, new String[0]), SoundEnum.MINOR_GOOD);
            TanChatUtils.message(renter, Lang.PROPERTY_RENTER_EXPELLED_RENTER_SIDE.get(renter, this.propertyData.getName()), SoundEnum.MINOR_BAD);
            this.open();
        }).asGuiItem(this.player, this.langType);
    }
}

