/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.ranks;

import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.dataclass.RankData;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.gui.IteratorGUI;
import org.leralix.tan.gui.user.ranks.RankManagerMenu;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.storage.stored.PlayerDataStorage;
import org.leralix.tan.utils.deprecated.GuiUtil;
import org.leralix.tan.utils.text.TanChatUtils;

public class AssignPlayerToRankMenu
extends IteratorGUI {
    private final TerritoryData territoryData;
    private final RankData rankData;

    public AssignPlayerToRankMenu(Player player, TerritoryData territoryData, RankData rankData) {
        super(player, Lang.HEADER_RANK_ADD_PLAYER.get(), 3);
        this.territoryData = territoryData;
        this.rankData = rankData;
    }

    @Override
    public void open() {
        GuiUtil.createIterator(this.gui, this.getAvailablePlayers(), this.page, this.player, p -> new RankManagerMenu(this.player, this.territoryData, this.rankData), p -> this.nextPage(), p -> this.previousPage());
        this.gui.open((HumanEntity)this.player);
    }

    private List<GuiItem> getAvailablePlayers() {
        ArrayList<GuiItem> playersToAdd = new ArrayList<GuiItem>();
        for (String otherPlayerUUID : this.territoryData.getPlayerIDList()) {
            ITanPlayer otherITanPlayer = PlayerDataStorage.getInstance().get(otherPlayerUUID);
            if (Objects.equals(otherITanPlayer.getRankID(this.territoryData), this.rankData.getID())) continue;
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(otherPlayerUUID));
            playersToAdd.add(this.iconManager.get(offlinePlayer).setName(offlinePlayer.getName()).setAction(action -> {
                action.setCancelled(true);
                RankData otherPlayerActualRank = this.territoryData.getRank(otherITanPlayer);
                if (this.territoryData.getRank(this.player).getLevel() <= otherPlayerActualRank.getLevel() && !this.territoryData.isLeader(this.tanPlayer)) {
                    TanChatUtils.message(this.player, Lang.PLAYER_NO_PERMISSION_RANK_DIFFERENCE.get(this.tanPlayer));
                    return;
                }
                ITanPlayer playerStat = PlayerDataStorage.getInstance().get(otherPlayerUUID);
                this.territoryData.setPlayerRank(playerStat, this.rankData);
                new RankManagerMenu(this.player, this.territoryData, this.rankData).open();
            }).asGuiItem(this.player, this.langType));
        }
        return playersToAdd;
    }
}

