/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.territory;

import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.leralix.lib.data.SoundEnum;
import org.leralix.lib.utils.SoundUtil;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.enums.RolePermission;
import org.leralix.tan.enums.permissions.ChunkPermissionType;
import org.leralix.tan.gui.BasicGui;
import org.leralix.tan.gui.IteratorGUI;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.storage.stored.PlayerDataStorage;
import org.leralix.tan.utils.text.TanChatUtils;

public class AddPlayerForChunkPermission
extends IteratorGUI {
    private final TerritoryData territoryData;
    private final ChunkPermissionType type;
    private final BasicGui backMenu;

    public AddPlayerForChunkPermission(Player player, TerritoryData territoryData, ChunkPermissionType type, BasicGui backMenu) {
        super(player, Lang.HEADER_AUTHORIZE_PLAYER, 6);
        this.territoryData = territoryData;
        this.type = type;
        this.backMenu = backMenu;
        this.open();
    }

    @Override
    public void open() {
        this.iterator(this.getPeopleToAuthorized(), p -> this.backMenu.open());
        this.gui.open((HumanEntity)this.player);
    }

    private List<GuiItem> getPeopleToAuthorized() {
        ITanPlayer playerStat = PlayerDataStorage.getInstance().get(this.player.getUniqueId().toString());
        ArrayList<GuiItem> guiItems = new ArrayList<GuiItem>();
        for (Player playerToAdd : Bukkit.getOnlinePlayers()) {
            ITanPlayer playerToAddData = PlayerDataStorage.getInstance().get(playerToAdd);
            if (this.territoryData.getPermission(this.type).isAllowed(this.territoryData, playerToAddData)) continue;
            guiItems.add(this.iconManager.get((OfflinePlayer)playerToAdd).setName(playerToAdd.getName()).setDescription(Lang.GUI_GENERIC_ADD_BUTTON.get()).setAction(action -> {
                if (!this.territoryData.doesPlayerHavePermission(playerStat, RolePermission.MANAGE_CLAIM_SETTINGS)) {
                    TanChatUtils.message(this.player, Lang.PLAYER_NO_PERMISSION.get(this.tanPlayer));
                    return;
                }
                this.territoryData.getPermission(this.type).addSpecificPlayerPermission(playerToAdd.getUniqueId().toString());
                this.open();
                SoundUtil.playSound((Player)this.player, (SoundEnum)SoundEnum.ADD);
            }).asGuiItem(this.player, this.langType));
        }
        return guiItems;
    }
}

