/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.territory;

import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.leralix.lib.data.SoundEnum;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.enums.RolePermission;
import org.leralix.tan.enums.permissions.ChunkPermissionType;
import org.leralix.tan.gui.BasicGui;
import org.leralix.tan.gui.IteratorGUI;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.gui.user.territory.AddPlayerForChunkPermission;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.utils.text.TanChatUtils;

public class OpenPlayerListForChunkPermission
extends IteratorGUI {
    private final TerritoryData territoryData;
    private final ChunkPermissionType chunkPermissionType;
    private final BasicGui backMenu;

    public OpenPlayerListForChunkPermission(Player player, TerritoryData territoryData, ChunkPermissionType type, BasicGui backMenu) {
        super(player, type.getLabel(), 6);
        this.territoryData = territoryData;
        this.chunkPermissionType = type;
        this.backMenu = backMenu;
        this.open();
    }

    @Override
    public void open() {
        this.iterator(this.getAuthorizedPlayer(), p -> this.backMenu.open());
        this.gui.setItem(6, 4, this.getAddButton());
        this.gui.open((HumanEntity)this.player);
    }

    @NotNull
    private GuiItem getAddButton() {
        return this.iconManager.get(IconKey.ADD_NEW_PLAYER_PERMISSION_ICON).setName(Lang.GUI_GENERIC_ADD_BUTTON.get(this.langType, new String[0])).setAction(action -> {
            if (!this.territoryData.doesPlayerHavePermission(this.tanPlayer, RolePermission.MANAGE_CLAIM_SETTINGS)) {
                TanChatUtils.message(this.player, Lang.PLAYER_NO_PERMISSION.get(this.tanPlayer), SoundEnum.NOT_ALLOWED);
                return;
            }
            new AddPlayerForChunkPermission(this.player, this.territoryData, this.chunkPermissionType, this);
        }).asGuiItem(this.player, this.langType);
    }

    private List<GuiItem> getAuthorizedPlayer() {
        ArrayList<GuiItem> guiItems = new ArrayList<GuiItem>();
        for (String authorizedPlayerID : this.territoryData.getPermission(this.chunkPermissionType).getAuthorizedPlayers()) {
            OfflinePlayer authorizedPlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(authorizedPlayerID));
            guiItems.add(this.iconManager.get(authorizedPlayer).setName(authorizedPlayer.getName()).setDescription(Lang.GUI_TOWN_MEMBER_DESC3.get()).setAction(action -> {
                action.setCancelled(true);
                if (!this.territoryData.doesPlayerHavePermission(this.tanPlayer, RolePermission.MANAGE_CLAIM_SETTINGS)) {
                    TanChatUtils.message(this.player, Lang.PLAYER_NO_PERMISSION.get(this.tanPlayer));
                    return;
                }
                if (action.isRightClick()) {
                    this.territoryData.getPermission(this.chunkPermissionType).removeSpecificPlayerPermission(authorizedPlayerID);
                    this.open();
                }
            }).asGuiItem(this.player, this.langType));
        }
        return guiItems;
    }
}

