/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.territory;

import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.leralix.lib.data.SoundEnum;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.dataclass.territory.RegionData;
import org.leralix.tan.gui.IteratorGUI;
import org.leralix.tan.gui.admin.AdminManageRegion;
import org.leralix.tan.gui.common.ConfirmMenu;
import org.leralix.tan.gui.user.territory.RegionSettingsMenu;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.storage.stored.PlayerDataStorage;
import org.leralix.tan.utils.file.FileUtil;

public class RegionChangeOwnership
extends IteratorGUI {
    private final RegionData regionData;

    public RegionChangeOwnership(Player player, RegionData regionData) {
        super(player, Lang.HEADER_CHANGE_OWNERSHIP, 6);
        this.regionData = regionData;
        this.open();
    }

    @Override
    public void open() {
        this.iterator(this.getCandidates(), p -> new AdminManageRegion(this.player, this.regionData));
        this.gui.open((HumanEntity)this.player);
    }

    private List<GuiItem> getCandidates() {
        ArrayList<GuiItem> guiItems = new ArrayList<GuiItem>();
        for (String playerID : this.regionData.getPlayerIDList()) {
            ITanPlayer iterateTanPlayer = PlayerDataStorage.getInstance().get(playerID);
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(playerID));
            guiItems.add(this.iconManager.get(offlinePlayer).setName(offlinePlayer.getName()).setAction(action -> {
                action.setCancelled(true);
                new ConfirmMenu(this.player, Lang.GUI_CONFIRM_CHANGE_LEADER.get(iterateTanPlayer.getNameStored()), () -> {
                    FileUtil.addLineToHistory(Lang.HISTORY_REGION_CAPITAL_CHANGED.get(this.player.getName(), this.regionData.getCapital().getName(), this.tanPlayer.getTown().getName()));
                    this.regionData.setLeaderID(iterateTanPlayer.getID());
                    this.regionData.broadcastMessageWithSound(Lang.GUI_REGION_SETTINGS_REGION_CHANGE_LEADER_BROADCAST.get(iterateTanPlayer.getNameStored()), SoundEnum.GOOD);
                    if (!this.regionData.getCapital().getID().equals(iterateTanPlayer.getTown().getID())) {
                        this.regionData.broadCastMessage(Lang.GUI_REGION_SETTINGS_REGION_CHANGE_CAPITAL_BROADCAST.get(iterateTanPlayer.getTown().getName()));
                        this.regionData.setCapital(iterateTanPlayer.getTownId());
                    }
                    new RegionSettingsMenu(this.player, this.regionData);
                }, this::open);
            }).asGuiItem(this.player, this.langType));
        }
        return guiItems;
    }
}

