/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.territory;

import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.leralix.tan.dataclass.Landmark;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.dataclass.territory.TownData;
import org.leralix.tan.gui.IteratorGUI;
import org.leralix.tan.gui.user.territory.ChooseWarGoal;
import org.leralix.tan.gui.user.territory.SelectWarGoals;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.storage.stored.LandmarkStorage;
import org.leralix.tan.war.War;
import org.leralix.tan.war.legacy.WarRole;
import org.leralix.tan.war.legacy.wargoals.CaptureLandmarkWarGoal;

public class SelectLandmarkForCapture
extends IteratorGUI {
    private final WarRole warRole;
    private final TerritoryData territoryData;
    private final War war;
    private final TownData enemyTownData;

    public SelectLandmarkForCapture(Player player, TerritoryData territoryData, War war, WarRole warRole) {
        super(player, Lang.HEADER_SELECT_WARGOAL, 3);
        this.warRole = warRole;
        this.territoryData = territoryData;
        this.war = war;
        this.enemyTownData = (TownData)(war.isMainAttacker(territoryData) ? war.getMainDefender() : war.getMainAttacker());
        this.open();
    }

    @Override
    public void open() {
        this.iterator(this.getLandmarks(this.langType), p -> new ChooseWarGoal(this.player, this.territoryData, this.war, this.warRole));
        this.gui.open((HumanEntity)this.player);
    }

    private List<GuiItem> getLandmarks(LangType langType) {
        ArrayList<GuiItem> items = new ArrayList<GuiItem>();
        for (Landmark landmark : LandmarkStorage.getInstance().getLandmarkOf(this.enemyTownData)) {
            GuiItem item = this.iconManager.get(landmark.getIcon(langType)).setName(landmark.getName()).setClickToAcceptMessage(Lang.GUI_GENERIC_CLICK_TO_SELECT).setAction(event -> {
                this.war.addGoal(this.warRole, new CaptureLandmarkWarGoal(landmark));
                new SelectWarGoals(this.player, this.territoryData, this.war, this.warRole);
            }).asGuiItem(this.player, langType);
            items.add(item);
        }
        return items;
    }
}

