/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.territory;

import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.leralix.tan.dataclass.territory.TownData;
import org.leralix.tan.gui.IteratorGUI;
import org.leralix.tan.gui.common.ConfirmMenu;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.utils.text.TanChatUtils;

public class SelectNewOwnerForTownMenu
extends IteratorGUI {
    private final TownData townData;
    private final Runnable backMenu;

    public SelectNewOwnerForTownMenu(Player player, TownData townData, Runnable backMenu) {
        super(player, Lang.HEADER_CHANGE_OWNERSHIP, 3);
        this.townData = townData;
        this.backMenu = backMenu;
        this.open();
    }

    @Override
    public void open() {
        this.iterator(this.getCandidates(), p -> this.backMenu.run());
        this.gui.open((HumanEntity)this.player);
    }

    private List<GuiItem> getCandidates() {
        ArrayList<GuiItem> guiItems = new ArrayList<GuiItem>();
        for (String playerUUID : this.townData.getPlayerIDList()) {
            if (this.townData.isLeader(playerUUID)) continue;
            OfflinePlayer townPlayer = Bukkit.getServer().getOfflinePlayer(UUID.fromString(playerUUID));
            guiItems.add(this.iconManager.get(townPlayer).setName(townPlayer.getName()).setDescription(Lang.GUI_TOWN_SETTINGS_TRANSFER_OWNERSHIP_TO_SPECIFIC_PLAYER_DESC1.get(this.player.getName()), Lang.GUI_TOWN_SETTINGS_TRANSFER_OWNERSHIP_TO_SPECIFIC_PLAYER_DESC2.get()).setAction(action -> {
                action.setCancelled(true);
                new ConfirmMenu(this.player, Lang.GUI_CONFIRM_CHANGE_TOWN_LEADER.get(townPlayer.getName()), () -> {
                    this.townData.setLeaderID(townPlayer.getUniqueId().toString());
                    TanChatUtils.message(this.player, Lang.GUI_TOWN_SETTINGS_TRANSFER_OWNERSHIP_TO_SPECIFIC_PLAYER_SUCCESS.get(this.tanPlayer, townPlayer.getName()));
                    this.backMenu.run();
                }, this::open);
            }).asGuiItem(this.player, this.langType));
        }
        return guiItems;
    }
}

