/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.territory;

import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.leralix.lib.data.SoundEnum;
import org.leralix.lib.utils.SoundUtil;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.gui.IteratorGUI;
import org.leralix.tan.gui.user.territory.ChooseWarGoal;
import org.leralix.tan.gui.user.territory.SelectWarGoals;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.war.War;
import org.leralix.tan.war.legacy.WarRole;
import org.leralix.tan.war.legacy.wargoals.LiberateWarGoal;

public class SelectTerritoryForLIberation
extends IteratorGUI {
    private final WarRole warRole;
    private final TerritoryData territoryData;
    private final War war;
    private final TerritoryData enemyTerritory;

    public SelectTerritoryForLIberation(Player player, TerritoryData territoryData, War war, WarRole warRole) {
        super(player, Lang.HEADER_SELECT_WARGOAL, 3);
        this.warRole = warRole;
        this.territoryData = territoryData;
        this.war = war;
        this.enemyTerritory = war.isMainAttacker(territoryData) ? war.getMainDefender() : war.getMainAttacker();
        this.open();
    }

    @Override
    public void open() {
        this.iterator(this.getTerritoryToLiberate(), p -> new ChooseWarGoal(this.player, this.territoryData, this.war, this.warRole));
        this.gui.open((HumanEntity)this.player);
    }

    private List<GuiItem> getTerritoryToLiberate() {
        ArrayList<GuiItem> items = new ArrayList<GuiItem>();
        for (TerritoryData territory : this.enemyTerritory.getVassals()) {
            if (territory.isCapital()) continue;
            items.add(this.iconManager.get(territory.getIcon()).setName(territory.getName()).setClickToAcceptMessage(Lang.GUI_GENERIC_CLICK_TO_SELECT).setAction(action -> {
                SoundUtil.playSound((Player)this.player, (SoundEnum)SoundEnum.MINOR_GOOD);
                this.war.addGoal(this.warRole, new LiberateWarGoal(territory));
                new SelectWarGoals(this.player, this.territoryData, this.war, this.warRole);
            }).asGuiItem(this.player, this.langType));
        }
        return items;
    }
}

