/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.territory;

import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.leralix.lib.data.SoundEnum;
import org.leralix.lib.utils.SoundUtil;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.enums.RolePermission;
import org.leralix.tan.enums.permissions.GeneralChunkSetting;
import org.leralix.tan.gui.IteratorGUI;
import org.leralix.tan.gui.user.territory.ChunkSettingsMenu;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.utils.deprecated.GuiUtil;
import org.leralix.tan.utils.text.TanChatUtils;

public class TerritoryChunkGeneralSettings
extends IteratorGUI {
    private final TerritoryData territoryData;

    public TerritoryChunkGeneralSettings(Player player, TerritoryData territoryData) {
        super(player, Lang.HEADER_CHUNK_GENERAL_SETTINGS, 3);
        this.territoryData = territoryData;
        this.open();
    }

    @Override
    public void open() {
        this.iterator(this.getSettings(), p -> new ChunkSettingsMenu(this.player, this.territoryData));
        this.gui.setItem(3, 1, GuiUtil.createBackArrow(this.player, p -> new ChunkSettingsMenu(this.player, this.territoryData)));
        this.gui.open((HumanEntity)this.player);
    }

    private List<GuiItem> getSettings() {
        ArrayList<GuiItem> res = new ArrayList<GuiItem>();
        Map<GeneralChunkSetting, Boolean> generalSettings = this.territoryData.getChunkSettings().getChunkSetting();
        for (GeneralChunkSetting generalChunkSetting : GeneralChunkSetting.values()) {
            boolean settingType = generalSettings.getOrDefault((Object)generalChunkSetting, false);
            res.add(generalChunkSetting.getIcon(this.iconManager, settingType, this.tanPlayer.getLang()).setAction(action -> {
                if (!this.territoryData.doesPlayerHavePermission(this.player, RolePermission.MANAGE_CLAIM_SETTINGS)) {
                    TanChatUtils.message(this.player, Lang.PLAYER_NO_PERMISSION.get(this.tanPlayer), SoundEnum.NOT_ALLOWED);
                    return;
                }
                generalSettings.put(generalChunkSetting, (Boolean)generalSettings.get((Object)generalChunkSetting) == false);
                SoundUtil.playSound((Player)this.player, (SoundEnum)SoundEnum.ADD);
                this.open();
            }).asGuiItem(this.player, this.langType));
        }
        return res;
    }
}

