/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.territory;

import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.dataclass.territory.TownData;
import org.leralix.tan.economy.EconomyUtil;
import org.leralix.tan.enums.RolePermission;
import org.leralix.tan.gui.IteratorGUI;
import org.leralix.tan.gui.common.ConfirmMenu;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.gui.cosmetic.IconManager;
import org.leralix.tan.gui.cosmetic.type.IconBuilder;
import org.leralix.tan.gui.service.requirements.RankPermissionRequirement;
import org.leralix.tan.gui.user.territory.PlayerApplicationMenu;
import org.leralix.tan.gui.user.territory.TerritoryRanksMenu;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.storage.stored.PlayerDataStorage;
import org.leralix.tan.utils.text.TanChatUtils;

public class TerritoryMemberMenu
extends IteratorGUI {
    private final TerritoryData territoryData;

    public TerritoryMemberMenu(Player player, TerritoryData territoryData) {
        super(player, Lang.HEADER_TOWN_MEMBERS, 6);
        this.territoryData = territoryData;
    }

    @Override
    public void open() {
        this.iterator(this.getMemberList(), p -> this.territoryData.openMainMenu(this.player));
        this.gui.setItem(6, 4, this.getManageRankButton());
        TerritoryData territoryData = this.territoryData;
        if (territoryData instanceof TownData) {
            TownData townData = (TownData)territoryData;
            this.gui.setItem(6, 5, this.getManageApplicationsButton(townData));
        }
        this.gui.open((HumanEntity)this.player);
    }

    private List<GuiItem> getMemberList() {
        ArrayList<GuiItem> players = new ArrayList<GuiItem>();
        PlayerDataStorage playerDataStorage = PlayerDataStorage.getInstance();
        for (String playerUUID : this.territoryData.getOrderedPlayerIDList()) {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(playerUUID));
            ITanPlayer playerToIterate = playerDataStorage.get(offlinePlayer);
            IconBuilder iconBuilder = this.iconManager.get(offlinePlayer).setName(offlinePlayer.getName()).setDescription(Lang.GUI_TOWN_MEMBER_DESC1.get(playerToIterate.getRank(this.territoryData).getColoredName()), Lang.GUI_TOWN_MEMBER_DESC2.get(Double.toString(EconomyUtil.getBalance(playerToIterate))));
            TerritoryData territoryData = this.territoryData;
            if (territoryData instanceof TownData) {
                TownData townData = (TownData)territoryData;
                this.addKickPlayerOption(townData, iconBuilder, playerToIterate, offlinePlayer);
            }
            players.add(iconBuilder.asGuiItem(this.player, this.langType));
        }
        return players;
    }

    private void addKickPlayerOption(TownData townData, IconBuilder iconBuilder, ITanPlayer playerToIterate, OfflinePlayer offlinePlayer) {
        iconBuilder.setClickToAcceptMessage(Lang.GUI_TOWN_MEMBER_DESC3).setAction(event -> {
            if (event.getClick() != ClickType.RIGHT) {
                return;
            }
            if (!this.territoryData.doesPlayerHavePermission(this.tanPlayer, RolePermission.KICK_PLAYER)) {
                TanChatUtils.message(this.player, Lang.PLAYER_NO_PERMISSION.get(this.langType, new String[0]));
                return;
            }
            if (this.territoryData.getRank(playerToIterate).isSuperiorTo(townData.getRank(this.tanPlayer))) {
                TanChatUtils.message(this.player, Lang.PLAYER_NO_PERMISSION_RANK_DIFFERENCE.get(this.langType, new String[0]));
                return;
            }
            if (this.territoryData.isLeader(playerToIterate)) {
                TanChatUtils.message(this.player, Lang.GUI_TOWN_MEMBER_CANT_KICK_LEADER.get(this.langType, new String[0]));
                return;
            }
            if (playerToIterate.getID().equals(this.tanPlayer.getID())) {
                TanChatUtils.message(this.player, Lang.GUI_TOWN_MEMBER_CANT_KICK_YOURSELF.get(this.langType, new String[0]));
                return;
            }
            new ConfirmMenu(this.player, Lang.CONFIRM_PLAYER_KICKED.get(offlinePlayer.getName()), () -> {
                townData.kickPlayer(offlinePlayer);
                this.open();
            }, this::open);
        });
    }

    private GuiItem getManageRankButton() {
        return IconManager.getInstance().get(IconKey.MANAGE_RANKS_ICON).setName(Lang.GUI_TOWN_MEMBERS_MANAGE_ROLES.get(this.langType, new String[0])).setRequirements(new RankPermissionRequirement(this.territoryData, this.tanPlayer, RolePermission.MANAGE_RANKS)).setAction(p -> new TerritoryRanksMenu(this.player, this.territoryData).open()).asGuiItem(this.player, this.langType);
    }

    private GuiItem getManageApplicationsButton(TownData townData) {
        return IconManager.getInstance().get(IconKey.MANAGE_APPLICATIONS_ICON).setName(Lang.GUI_TOWN_MEMBERS_MANAGE_APPLICATION.get(this.langType, new String[0])).setRequirements(new RankPermissionRequirement(this.territoryData, this.tanPlayer, RolePermission.INVITE_PLAYER)).setDescription(Lang.GUI_TOWN_MEMBERS_MANAGE_APPLICATION_DESC1.get(Integer.toString(townData.getPlayerJoinRequestSet().size()))).setAction(p -> new PlayerApplicationMenu(this.player, townData).open()).asGuiItem(this.player, this.langType);
    }
}

