/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.territory;

import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.leralix.lib.data.SoundEnum;
import org.leralix.lib.utils.SoundUtil;
import org.leralix.tan.dataclass.ClaimedChunkSettings;
import org.leralix.tan.dataclass.UpgradeStatus;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.enums.MobChunkSpawnEnum;
import org.leralix.tan.enums.RolePermission;
import org.leralix.tan.gui.IteratorGUI;
import org.leralix.tan.gui.user.territory.ChunkSettingsMenu;
import org.leralix.tan.lang.FilledLang;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.storage.MobChunkSpawnStorage;
import org.leralix.tan.utils.text.TanChatUtils;

public class TerritoryMobSettings
extends IteratorGUI {
    private final TerritoryData territoryData;

    public TerritoryMobSettings(Player player, TerritoryData territoryData) {
        super(player, Lang.HEADER_MOB_SETTINGS, 6);
        this.territoryData = territoryData;
        this.open();
    }

    @Override
    public void open() {
        this.iterator(this.getMobs(), p -> new ChunkSettingsMenu(this.player, this.territoryData));
        this.gui.open((HumanEntity)this.player);
    }

    private List<GuiItem> getMobs() {
        ArrayList<GuiItem> guiLists = new ArrayList<GuiItem>();
        ClaimedChunkSettings chunkSettings = this.territoryData.getChunkSettings();
        Collection<MobChunkSpawnEnum> mobCollection = MobChunkSpawnStorage.getMobSpawnStorage().values();
        for (MobChunkSpawnEnum mobEnum : mobCollection) {
            UpgradeStatus upgradeStatus = chunkSettings.getSpawnControl(mobEnum);
            int cost = MobChunkSpawnStorage.getMobSpawnCost(mobEnum);
            List<FilledLang> status = this.generateDescription(upgradeStatus, cost);
            boolean upgradeBought = upgradeStatus.isUnlocked();
            guiLists.add(this.iconManager.get(mobEnum.getIconKey()).setName(mobEnum.name()).setDescription(status).setClickToAcceptMessage(upgradeBought ? Lang.GUI_GENERIC_CLICK_TO_SWITCH : Lang.GUI_GENERIC_CLICK_TO_UPGRADE).setAction(event -> {
                event.setCancelled(true);
                if (!this.territoryData.doesPlayerHavePermission(this.tanPlayer, RolePermission.MANAGE_MOB_SPAWN)) {
                    TanChatUtils.message(this.player, Lang.PLAYER_NO_PERMISSION.get(this.tanPlayer));
                    return;
                }
                if (upgradeStatus.isUnlocked()) {
                    upgradeStatus.setActivated(!upgradeStatus.canSpawn());
                    SoundUtil.playSound((Player)this.player, (SoundEnum)SoundEnum.ADD);
                } else {
                    if (this.territoryData.getBalance() < (double)cost) {
                        TanChatUtils.message(this.player, Lang.TERRITORY_NOT_ENOUGH_MONEY.get(this.tanPlayer, this.territoryData.getColoredName(), Double.toString((double)cost - this.territoryData.getBalance())));
                        return;
                    }
                    this.territoryData.removeFromBalance(cost);
                    SoundUtil.playSound((Player)this.player, (SoundEnum)SoundEnum.GOOD);
                    upgradeStatus.setUnlocked(true);
                }
                this.open();
            }).asGuiItem(this.player, this.langType));
        }
        return guiLists;
    }

    @NotNull
    private List<FilledLang> generateDescription(UpgradeStatus upgradeStatus, int cost) {
        ArrayList<FilledLang> status = new ArrayList<FilledLang>();
        if (upgradeStatus.isUnlocked()) {
            if (upgradeStatus.canSpawn()) {
                status.add(Lang.GUI_TOWN_CHUNK_MOB_SETTINGS_STATUS_ACTIVATED.get());
            } else {
                status.add(Lang.GUI_TOWN_CHUNK_MOB_SETTINGS_STATUS_DEACTIVATED.get());
            }
        } else {
            status.add(Lang.GUI_TOWN_CHUNK_MOB_SETTINGS_STATUS_LOCKED.get());
            status.add(Lang.GUI_TOWN_CHUNK_MOB_SETTINGS_STATUS_LOCKED2.get(Integer.toString(cost)));
        }
        return status;
    }
}

