/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.territory.hierarchy;

import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.leralix.lib.data.SoundEnum;
import org.leralix.lib.utils.SoundUtil;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.gui.IteratorGUI;
import org.leralix.tan.gui.user.territory.hierarchy.VassalsMenu;
import org.leralix.tan.lang.Lang;

public class AddVassalMenu
extends IteratorGUI {
    private final TerritoryData territoryData;

    public AddVassalMenu(Player player, TerritoryData territoryData) {
        super(player, Lang.HEADER_VASSALS, 6);
        this.territoryData = territoryData;
        this.open();
    }

    @Override
    public void open() {
        this.iterator(this.potentialVassals(), p -> new VassalsMenu(this.player, this.territoryData));
        this.gui.open((HumanEntity)this.player);
    }

    private List<GuiItem> potentialVassals() {
        ArrayList<GuiItem> guiItems = new ArrayList<GuiItem>();
        for (TerritoryData potentialVassal : this.territoryData.getPotentialVassals()) {
            if (this.territoryData.isVassal(potentialVassal) || potentialVassal.containsVassalisationProposal(this.territoryData)) continue;
            guiItems.add(potentialVassal.getIconWithInformationAndRelation(this.territoryData, this.tanPlayer.getLang()).setClickToAcceptMessage(Lang.GUI_REGION_INVITE_TOWN_DESC1).setAction(action -> {
                potentialVassal.addVassalisationProposal(this.territoryData);
                SoundUtil.playSound((Player)this.player, (SoundEnum)SoundEnum.MINOR_GOOD);
                this.open();
            }).asGuiItem(this.player, this.tanPlayer.getLang()));
        }
        return guiItems;
    }
}

