/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.territory.hierarchy;

import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.leralix.lib.data.SoundEnum;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.enums.RolePermission;
import org.leralix.tan.gui.IteratorGUI;
import org.leralix.tan.gui.common.ConfirmMenu;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.gui.legacy.PlayerGUI;
import org.leralix.tan.gui.service.requirements.RankPermissionRequirement;
import org.leralix.tan.gui.user.territory.hierarchy.AddVassalMenu;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.utils.text.TanChatUtils;

public class VassalsMenu
extends IteratorGUI {
    private final TerritoryData territoryData;

    public VassalsMenu(Player player, TerritoryData territoryData) {
        super(player, Lang.HEADER_VASSALS, 4);
        this.territoryData = territoryData;
        this.open();
    }

    @Override
    public void open() {
        this.iterator(this.getVassals(), p -> PlayerGUI.openHierarchyMenu(this.player, this.territoryData));
        this.gui.setItem(4, 3, this.getAddVassalButton());
        this.gui.open((HumanEntity)this.player);
    }

    @NotNull
    private GuiItem getAddVassalButton() {
        return this.iconManager.get(IconKey.ADD_VASSALS_ICON).setName(Lang.GUI_INVITE_TOWN_TO_REGION.get(this.tanPlayer)).setClickToAcceptMessage(Lang.GUI_GENERIC_CLICK_TO_PROCEED).setRequirements(new RankPermissionRequirement(this.territoryData, this.tanPlayer, RolePermission.TOWN_ADMINISTRATOR)).setAction(action -> new AddVassalMenu(this.player, this.territoryData)).asGuiItem(this.player, this.langType);
    }

    private List<GuiItem> getVassals() {
        ArrayList<GuiItem> res = new ArrayList<GuiItem>();
        for (TerritoryData vassal : this.territoryData.getVassals()) {
            GuiItem vassalButton = this.iconManager.get(vassal.getIcon()).setName(vassal.getColoredName()).setDescription(Lang.GUI_TOWN_INFO_DESC0.get(vassal.getDescription()), Lang.GUI_TOWN_INFO_DESC1.get(vassal.getLeaderName()), Lang.GUI_TOWN_INFO_DESC2.get(Integer.toString(vassal.getPlayerIDList().size())), Lang.GUI_TOWN_INFO_DESC3.get(Integer.toString(vassal.getNumberOfClaimedChunk()))).setClickToAcceptMessage(Lang.GUI_GENERIC_RIGHT_CLICK_TO_REMOVE).setAction(action -> {
                if (!action.isRightClick()) {
                    return;
                }
                if (vassal.isCapital()) {
                    TanChatUtils.message(this.player, Lang.CANT_KICK_REGIONAL_CAPITAL.get(this.tanPlayer, vassal.getName()), SoundEnum.NOT_ALLOWED);
                    return;
                }
                new ConfirmMenu(this.player, Lang.CONFIRM_VASSAL_KICK.get(vassal.getColoredName(), this.territoryData.getColoredName()), () -> {
                    this.territoryData.broadcastMessageWithSound(Lang.GUI_REGION_KICK_TOWN_BROADCAST.get(vassal.getName()), SoundEnum.BAD);
                    vassal.removeOverlord();
                    this.player.closeInventory();
                }, this::open);
            }).asGuiItem(this.player, this.langType);
            res.add(vassalButton);
        }
        return res;
    }
}

