/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.territory.history;

import java.lang.runtime.SwitchBootstraps;
import java.sql.Date;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.gui.user.territory.history.AbstractTransactionHistory;
import org.leralix.tan.storage.database.transactions.AbstractTransaction;
import org.leralix.tan.storage.database.transactions.EntityScope;
import org.leralix.tan.storage.database.transactions.TransactionType;
import org.leralix.tan.storage.database.transactions.instance.DailyPlayerTaxTransaction;
import org.leralix.tan.storage.database.transactions.instance.DailySalaryTransaction;
import org.leralix.tan.storage.database.transactions.instance.DailyTerritoryTaxTransaction;
import org.leralix.tan.storage.database.transactions.instance.PlayerTaxTransaction;
import org.leralix.tan.storage.database.transactions.instance.SalaryTransaction;
import org.leralix.tan.storage.database.transactions.instance.TerritoryTaxTransaction;

public class TerritoryTransactionHistory
extends AbstractTransactionHistory {
    private final TerritoryData territoryData;

    public TerritoryTransactionHistory(Player player, TerritoryData territoryData, Consumer<Player> guiCallback) {
        super(player, guiCallback);
        this.territoryData = territoryData;
        this.open();
    }

    public TerritoryTransactionHistory(Player player, TerritoryData territoryData, TransactionType transactionType, Consumer<Player> guiCallback) {
        super(player, guiCallback, transactionType);
        this.territoryData = territoryData;
        this.open();
    }

    @Override
    protected EntityScope getScope() {
        return EntityScope.TERRITORY;
    }

    @Override
    protected String getID() {
        return this.territoryData.getID();
    }

    @Override
    protected List<AbstractTransaction> fetchTransactions() {
        List<AbstractTransaction> transactions = super.fetchTransactions();
        ArrayList<AbstractTransaction> result = new ArrayList<AbstractTransaction>();
        ArrayList<PlayerTaxTransaction> taxTransactions = new ArrayList<PlayerTaxTransaction>();
        ArrayList<TerritoryTaxTransaction> territoryTaxTransactions = new ArrayList<TerritoryTaxTransaction>();
        ArrayList<SalaryTransaction> salaryTransactions = new ArrayList<SalaryTransaction>();
        block5: for (AbstractTransaction transaction : transactions) {
            AbstractTransaction abstractTransaction;
            Objects.requireNonNull(transaction);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PlayerTaxTransaction.class, TerritoryTaxTransaction.class, SalaryTransaction.class}, (Object)abstractTransaction, n)) {
                case 0: {
                    PlayerTaxTransaction playerTaxTransaction = (PlayerTaxTransaction)abstractTransaction;
                    taxTransactions.add(playerTaxTransaction);
                    continue block5;
                }
                case 1: {
                    TerritoryTaxTransaction territoryTaxTransaction = (TerritoryTaxTransaction)abstractTransaction;
                    territoryTaxTransactions.add(territoryTaxTransaction);
                    continue block5;
                }
                case 2: {
                    SalaryTransaction salaryTransaction = (SalaryTransaction)abstractTransaction;
                    salaryTransactions.add(salaryTransaction);
                    continue block5;
                }
            }
            result.add(transaction);
        }
        if (!taxTransactions.isEmpty()) {
            Map<LocalDate, List<PlayerTaxTransaction>> groupedTaxes = taxTransactions.stream().collect(Collectors.groupingBy(t -> new Date(t.getDate()).toLocalDate()));
            for (List<AbstractTransaction> list : groupedTaxes.values()) {
                result.add(new DailyPlayerTaxTransaction(list));
            }
        }
        if (!territoryTaxTransactions.isEmpty()) {
            Map<LocalDate, List<TerritoryTaxTransaction>> groupedTerritoryTaxes = territoryTaxTransactions.stream().collect(Collectors.groupingBy(t -> new Date(t.getDate()).toLocalDate()));
            for (List<AbstractTransaction> list : groupedTerritoryTaxes.values()) {
                result.add(new DailyTerritoryTaxTransaction(list));
            }
        }
        if (!salaryTransactions.isEmpty()) {
            Map<LocalDate, List<SalaryTransaction>> groupedSalaries = salaryTransactions.stream().collect(Collectors.groupingBy(t -> new Date(t.getDate()).toLocalDate()));
            for (List<AbstractTransaction> list : groupedSalaries.values()) {
                result.add(new DailySalaryTransaction(list));
            }
        }
        result.sort(Comparator.comparing(AbstractTransaction::getDate).reversed());
        return result;
    }
}

