/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.territory.upgrade;

import dev.triumphteam.gui.components.util.GuiFiller;
import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import java.util.Collections;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.leralix.lib.data.SoundEnum;
import org.leralix.lib.utils.config.ConfigTag;
import org.leralix.lib.utils.config.ConfigUtil;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.gui.BasicGui;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.gui.cosmetic.type.IconBuilder;
import org.leralix.tan.lang.FilledLang;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.upgrade.TerritoryStats;
import org.leralix.tan.upgrade.Upgrade;
import org.leralix.tan.upgrade.rewards.IndividualStat;
import org.leralix.tan.utils.constants.Constants;
import org.leralix.tan.utils.deprecated.GuiUtil;
import org.leralix.tan.utils.text.TanChatUtils;

public class UpgradeMenu
extends BasicGui {
    private final TerritoryData territoryData;
    private int scrollIndex;
    private final int maxLevel;

    public UpgradeMenu(Player player, TerritoryData territoryData) {
        super(player, Lang.HEADER_TOWN_UPGRADE, 6);
        this.territoryData = territoryData;
        this.scrollIndex = 0;
        this.maxLevel = ConfigUtil.getCustomConfig((ConfigTag)ConfigTag.MAIN).getInt("TownMaxLevel", 10);
        this.open();
    }

    @Override
    public void open() {
        this.generateMenuPart();
        this.generateUpgrades();
        this.gui.open((HumanEntity)this.player);
    }

    private void generateUpgrades() {
        this.gui.setItem(1, 1, this.getTerritoryStats(this.territoryData));
        TerritoryStats territoryStats = this.territoryData.getNewLevel();
        int townLevel = territoryStats.getMainLevel();
        GuiItem unlockedFiller = GuiUtil.getUnnamedItem(Material.LIME_STAINED_GLASS_PANE);
        IconBuilder unlockedLevels = this.iconManager.get(Material.GREEN_STAINED_GLASS_PANE);
        GuiItem lockedFiller = this.iconManager.get(Material.IRON_BARS).setName(Lang.LEVEL_LOCKED.get(this.langType, new String[0])).asGuiItem(this.player, this.langType);
        IconBuilder lockedLevels = this.iconManager.get(Material.RED_STAINED_GLASS_PANE);
        for (int i = 2; i < 10; ++i) {
            int adaptedCursor = i - 3 + this.scrollIndex;
            if (adaptedCursor > townLevel) {
                this.gui.getFiller().fillBetweenPoints(1, i, 4, i, lockedFiller);
                this.gui.setItem(5, i, lockedLevels.setName(Lang.LEVEL_LOCKED_WITH_LEVEL.get(this.langType, Integer.toString(i))).asGuiItem(this.player, this.langType));
                continue;
            }
            if (adaptedCursor == townLevel) {
                this.gui.getFiller().fillBetweenPoints(1, i, 4, i, lockedFiller);
                this.gui.setItem(5, i, this.getUpgradeTownButton());
                continue;
            }
            this.gui.getFiller().fillBetweenPoints(1, i, 4, i, unlockedFiller);
            this.gui.setItem(5, i, unlockedLevels.setName(Lang.LEVEL_UNLOCKED_WITH_LEVEL.get(this.langType, Integer.toString(i))).asGuiItem(this.player, this.langType));
        }
        for (Upgrade upgrade : Constants.getUpgradeStorage().getUpgrades(this.territoryData)) {
            int row = upgrade.getRow() + 1;
            int column = upgrade.getColumn() + 2 - this.scrollIndex;
            if (column > 9 || column < 2 || row > 4 || row < 1) continue;
            int levelOfUpgrade = territoryStats.getLevel(upgrade);
            int maxLevelOfUpgrade = upgrade.getMaxLevel();
            ArrayList<FilledLang> desc = new ArrayList<FilledLang>();
            desc.add(Lang.UPGRADE_CURRENT_LEVEL.get(Integer.toString(levelOfUpgrade), Integer.toString(maxLevelOfUpgrade)));
            desc.add(Lang.EMPTY.get());
            desc.add(Lang.GUI_TOWN_LEVEL_UP_UNI_DESC4.get());
            for (IndividualStat individualStat : upgrade.getRewards()) {
                desc.add(individualStat.getStatReward(this.langType, levelOfUpgrade, maxLevelOfUpgrade));
            }
            this.gui.setItem(row, column, this.iconManager.get(upgrade.getIconMaterial()).setName(upgrade.getName(this.langType)).setDescription(desc).setRequirements(upgrade.getRequirements(this.territoryData, this.player)).setClickToAcceptMessage(Lang.GUI_GENERIC_CLICK_TO_UPGRADE).setAction(action -> {
                if (levelOfUpgrade >= maxLevelOfUpgrade) {
                    TanChatUtils.message(this.player, Lang.TOWN_UPGRADE_MAX_LEVEL.get(this.langType, new String[0]), SoundEnum.NOT_ALLOWED);
                    return;
                }
                TanChatUtils.message(this.player, Lang.BASIC_LEVEL_UP.get(this.langType, new String[0]), SoundEnum.LEVEL_UP);
                this.territoryData.getNewLevel().levelUp(upgrade);
                this.open();
            }).asGuiItem(this.player, this.langType));
        }
    }

    @NotNull
    private GuiItem getTerritoryStats(TerritoryData territoryData) {
        ArrayList<FilledLang> desc = new ArrayList<FilledLang>();
        desc.add(Lang.EMPTY.get());
        for (IndividualStat stat : territoryData.getNewLevel().getAllStats()) {
            desc.add(stat.getStatReward(this.langType));
        }
        return this.iconManager.get(territoryData.getIcon()).setName(territoryData.getName()).setDescription(desc).asGuiItem(this.player, this.langType);
    }

    private void generateMenuPart() {
        this.gui.getFiller().fillBottom(GuiUtil.getUnnamedItem(Material.GRAY_STAINED_GLASS_PANE));
        this.gui.getFiller().fillSide(GuiFiller.Side.LEFT, Collections.singletonList(GuiUtil.getUnnamedItem(Material.GRAY_STAINED_GLASS_PANE)));
        this.gui.setItem(6, 8, this.getRightButton());
        this.gui.setItem(6, 7, this.getLeftButton());
        this.gui.setItem(6, 1, GuiUtil.createBackArrow(this.player, this.territoryData::openMainMenu));
    }

    @NotNull
    private GuiItem getUpgradeTownButton() {
        TerritoryStats level = this.territoryData.getNewLevel();
        int currentLevel = level.getMainLevel();
        int nextLevelPrice = level.getMoneyRequiredForLevelUp();
        return this.iconManager.get(IconKey.LEVEL_UP_ICON).setName(Lang.GUI_TOWN_LEVEL_UP.get(this.langType, new String[0])).setDescription(Lang.GUI_TOWN_LEVEL_UP_DESC1.get(Integer.toString(currentLevel)), Lang.GUI_TOWN_LEVEL_UP_DESC2.get(Integer.toString(currentLevel + 1), Integer.toString(nextLevelPrice))).setClickToAcceptMessage(Lang.GUI_GENERIC_CLICK_TO_PROCEED).setAction(action -> {
            this.territoryData.getNewLevel().levelUpMain();
            TanChatUtils.message(this.player, Lang.BASIC_LEVEL_UP.get(this.langType, new String[0]), SoundEnum.LEVEL_UP);
            this.open();
        }).asGuiItem(this.player, this.langType);
    }

    @NotNull
    private GuiItem getRightButton() {
        return this.iconManager.get(IconKey.RIGHT_ARROW).setName(Lang.GUI_GENERIC_UP.get(this.langType, new String[0])).setClickToAcceptMessage(Lang.GUI_GENERIC_CLICK_TO_PROCEED).setAction(action -> {
            this.scrollIndex = Math.min(this.maxLevel, this.scrollIndex + 1);
            this.generateUpgrades();
            this.gui.open((HumanEntity)this.player);
        }).asGuiItem(this.player, this.langType);
    }

    @NotNull
    private GuiItem getLeftButton() {
        return this.iconManager.get(IconKey.LEFT_ARROW).setName(Lang.GUI_GENERIC_DOWN.get(this.langType, new String[0])).setClickToAcceptMessage(Lang.GUI_GENERIC_CLICK_TO_PROCEED).setAction(action -> {
            this.scrollIndex = Math.max(0, this.scrollIndex - 1);
            this.generateUpgrades();
            this.gui.open((HumanEntity)this.player);
        }).asGuiItem(this.player, this.langType);
    }
}

