/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.war;

import dev.triumphteam.gui.builder.item.ItemBuilder;
import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.leralix.lib.data.SoundEnum;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.gui.BasicGui;
import org.leralix.tan.gui.user.territory.AttackMenu;
import org.leralix.tan.lang.FilledLang;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.listeners.chat.PlayerChatListenerStorage;
import org.leralix.tan.listeners.chat.events.ChangeAttackName;
import org.leralix.tan.utils.deprecated.GuiUtil;
import org.leralix.tan.utils.deprecated.HeadUtils;
import org.leralix.tan.utils.text.TanChatUtils;
import org.leralix.tan.war.PlannedAttack;
import org.leralix.tan.war.info.AttackResultCancelled;
import org.leralix.tan.war.legacy.WarRole;

public class PlannedAttackMenu
extends BasicGui {
    private final TerritoryData territoryData;
    private final PlannedAttack plannedAttack;
    private final WarRole warRole;

    public PlannedAttackMenu(Player player, TerritoryData territoryData, PlannedAttack plannedAttack) {
        super(player, Lang.HEADER_WAR_MANAGER, 3);
        this.territoryData = territoryData;
        this.plannedAttack = plannedAttack;
        this.warRole = plannedAttack.getTerritoryRole(territoryData);
        this.open();
    }

    @Override
    public void open() {
        this.gui.setItem(1, 5, this.getAttackIcon());
        this.gui.setItem(2, 2, this.getAttackingSideSidePanel());
        this.gui.setItem(2, 4, this.getDefendingSidePanel());
        if (this.warRole == WarRole.MAIN_ATTACKER) {
            ItemStack cancelAttack = HeadUtils.createCustomItemStack(Material.BARRIER, Lang.GUI_CANCEL_ATTACK.get(this.tanPlayer), Lang.GUI_GENERIC_CLICK_TO_DELETE.get(this.tanPlayer));
            ItemStack renameAttack = HeadUtils.createCustomItemStack(Material.NAME_TAG, Lang.GUI_RENAME_ATTACK.get(this.tanPlayer), Lang.GUI_GENERIC_CLICK_TO_RENAME.get(this.tanPlayer));
            GuiItem cancelButton = ItemBuilder.from(cancelAttack).asGuiItem(event -> {
                this.plannedAttack.end(new AttackResultCancelled());
                this.territoryData.broadcastMessageWithSound(Lang.ATTACK_SUCCESSFULLY_CANCELLED.get(this.plannedAttack.getWar().getMainDefender().getName()), SoundEnum.MINOR_GOOD);
                new AttackMenu(this.player, this.territoryData);
            });
            GuiItem renameButton = ItemBuilder.from(renameAttack).asGuiItem(event -> {
                event.setCancelled(true);
                TanChatUtils.message(this.player, Lang.ENTER_NEW_VALUE.get(this.tanPlayer));
                PlayerChatListenerStorage.register(this.player, new ChangeAttackName(this.plannedAttack, p -> this.open()));
            });
            this.gui.setItem(2, 6, renameButton);
            this.gui.setItem(2, 8, cancelButton);
        } else if (this.warRole == WarRole.MAIN_DEFENDER) {
            ArrayList<FilledLang> submitDescription = new ArrayList<FilledLang>();
            submitDescription.add(Lang.SUBMIT_TO_REQUEST_DESC1.get());
            submitDescription.addAll(this.plannedAttack.getWar().generateWarGoalsDesciption(this.warRole, this.langType));
            this.gui.setItem(2, 7, this.iconManager.get(Material.SOUL_LANTERN).setName(Lang.SUBMIT_TO_REQUESTS.get(this.langType, new String[0])).setDescription(submitDescription).setAction(event -> {
                this.plannedAttack.territorySurrendered();
                new AttackMenu(this.player, this.territoryData);
            }).asGuiItem(this.player, this.langType));
        } else if (this.warRole == WarRole.OTHER_ATTACKER || this.warRole == WarRole.OTHER_DEFENDER) {
            this.gui.setItem(2, 7, this.iconManager.get(Material.DARK_OAK_DOOR).setName(Lang.GUI_QUIT_WAR.get(this.langType, new String[0])).setDescription(Lang.GUI_QUIT_WAR_DESC1.get()).setAction(event -> {
                this.plannedAttack.removeBelligerent(this.territoryData);
                this.territoryData.broadcastMessageWithSound(Lang.TERRITORY_NO_LONGER_INVOLVED_IN_WAR_MESSAGE.get(this.plannedAttack.getWar().getMainDefender().getName()), SoundEnum.MINOR_GOOD);
                new AttackMenu(this.player, this.territoryData);
            }).asGuiItem(this.player, this.langType));
        } else if (this.warRole == WarRole.NEUTRAL) {
            ArrayList<FilledLang> description = new ArrayList<FilledLang>();
            description.add(Lang.GUI_JOIN_ATTACKING_SIDE_DESC1.get(this.territoryData.getBaseColoredName()));
            description.addAll(this.plannedAttack.getWar().generateWarGoalsDesciption(this.warRole, this.langType));
            this.gui.setItem(2, 6, this.iconManager.get(Material.IRON_SWORD).setName(Lang.GUI_JOIN_ATTACKING_SIDE.get(this.langType, new String[0])).setDescription(description).setAction(event -> {
                this.plannedAttack.addAttacker(this.territoryData);
                this.open();
            }).asGuiItem(this.player, this.langType));
            this.gui.setItem(2, 8, this.iconManager.get(Material.SHIELD).setName(Lang.GUI_JOIN_DEFENDING_SIDE.get(this.tanPlayer)).setDescription(Lang.GUI_JOIN_DEFENDING_SIDE_DESC1.get(this.territoryData.getBaseColoredName())).setAction(event -> {
                this.plannedAttack.addDefender(this.territoryData);
                this.open();
            }).asGuiItem(this.player, this.langType));
        }
        this.gui.setItem(3, 1, GuiUtil.createBackArrow(this.player, p -> new AttackMenu(this.player, this.territoryData)));
        this.gui.open((HumanEntity)this.player);
    }

    @NotNull
    private GuiItem getDefendingSidePanel() {
        return ItemBuilder.from(this.plannedAttack.getDefendingIcon(this.langType)).asGuiItem();
    }

    @NotNull
    private GuiItem getAttackingSideSidePanel() {
        return ItemBuilder.from(this.plannedAttack.getAttackingIcon(this.langType)).asGuiItem();
    }

    @NotNull
    private GuiItem getAttackIcon() {
        return this.plannedAttack.getIcon(this.iconManager, this.tanPlayer.getLang(), this.tanPlayer.getTimeZone(), this.territoryData).asGuiItem(this.player, this.langType);
    }
}

